/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.playback;

import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.lovetropics.multimedia.AudioPacket;
import org.lovetropics.multimedia.MultimediaPacket;
import org.lovetropics.multimedia.MultimediaReader;
import org.lovetropics.multimedia.VideoPacket;
import org.lovetropics.multimedia.mod.client.playback.Playback;
import org.slf4j.Logger;

class PacketReader
implements AutoCloseable {
    private static final int MAX_QUEUE_CAPACITY = 64;
    private static final int PREFERRED_QUEUE_SIZE = 32;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MultimediaReader reader;
    private final Thread thread;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition wakeUp = this.lock.newCondition();
    private final PacketQueue<VideoPacket> videoQueue = new PacketQueue(64, 32);
    private final PacketQueue<AudioPacket> audioQueue = new PacketQueue(64, 32);
    @Nullable
    private volatile SeekRequest seekRequest;
    private volatile boolean eof;
    private volatile boolean sleeping;
    private volatile boolean closed;

    PacketReader(MultimediaReader reader) {
        this.reader = reader;
        this.thread = Playback.IO_THREAD_BUILDER.start(this::run);
    }

    public void discardVideo() {
        this.videoQueue.discard();
    }

    public void discardAudio() {
        this.audioQueue.discard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> seekTo(double time) {
        this.lock.lock();
        try {
            SeekRequest oldRequest = this.seekRequest;
            CompletableFuture<Void> future = oldRequest != null ? oldRequest.future : new CompletableFuture<Void>();
            this.seekRequest = new SeekRequest(time, future);
            this.videoQueue.clear();
            this.audioQueue.clear();
            this.eof = false;
            if (this.sleeping) {
                this.wakeUp.signal();
            }
            CompletableFuture<Void> completableFuture = future;
            return completableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public VideoPacket takeVideoPacket() {
        try {
            return this.videoQueue.take();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Nullable
    public AudioPacket pollAudioPacket() {
        return this.audioQueue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        try {
            while (!this.closed) {
                this.handleSeekRequest();
                MultimediaPacket packet = this.reader.readPacket();
                if (packet != null) {
                    this.enqueueAndSleep(packet);
                    continue;
                }
                this.markEofAndSleep();
            }
        }
        catch (InterruptedException | ClosedByInterruptException packet) {
        }
        catch (IOException e) {
            LOGGER.error("Failed to read packet from stream", (Throwable)e);
        }
        finally {
            this.lock.lock();
            try {
                this.videoQueue.discard();
                this.audioQueue.discard();
            }
            finally {
                this.lock.unlock();
            }
            IOUtils.closeQuietly((Closeable)this.reader);
        }
    }

    private void enqueueAndSleep(MultimediaPacket packet) throws InterruptedException {
        MultimediaPacket multimediaPacket = packet;
        Objects.requireNonNull(multimediaPacket);
        MultimediaPacket multimediaPacket2 = multimediaPacket;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VideoPacket.class, AudioPacket.class}, (Object)multimediaPacket2, n)) {
            case 0: {
                VideoPacket videoPacket = (VideoPacket)multimediaPacket2;
                this.enqueueAndSleep(this.videoQueue, videoPacket);
                break;
            }
            case 1: {
                AudioPacket audioPacket = (AudioPacket)multimediaPacket2;
                this.enqueueAndSleep(this.audioQueue, audioPacket);
                break;
            }
            default: {
                packet.close();
            }
        }
    }

    private <P extends MultimediaPacket> void enqueueAndSleep(PacketQueue<P> queue, P packet) throws InterruptedException {
        if (queue.discard) {
            packet.close();
            return;
        }
        this.lock.lock();
        try {
            if (this.seekRequest != null) {
                packet.close();
                return;
            }
            if (queue.enqueue(packet) && this.shouldSleep()) {
                this.sleeping = true;
                this.wakeUp.await();
                this.sleeping = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void markEofAndSleep() throws InterruptedException {
        this.lock.lock();
        try {
            this.eof = true;
            this.sleeping = true;
            this.wakeUp.await();
            this.sleeping = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean shouldSleep() {
        if (this.eof) {
            return true;
        }
        if (!this.videoQueue.wantsPacket() && !this.audioQueue.wantsPacket()) {
            return true;
        }
        if (this.videoQueue.needsPacket() || this.audioQueue.needsPacket()) {
            return false;
        }
        return !this.videoQueue.canAcceptPacket() || !this.audioQueue.canAcceptPacket();
    }

    private void handleSeekRequest() throws IOException {
        SeekRequest request;
        if (this.seekRequest == null) {
            return;
        }
        this.lock.lock();
        try {
            request = Objects.requireNonNull(this.seekRequest);
            this.seekRequest = null;
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.reader.seekTo(request.time);
            request.future.complete(null);
        }
        catch (IOException e) {
            request.future.completeExceptionally(e);
        }
    }

    public boolean isEof() {
        return this.eof;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.thread.interrupt();
        this.lock.lock();
        try {
            this.videoQueue.discard();
            this.audioQueue.discard();
        }
        finally {
            this.lock.unlock();
        }
    }

    private class PacketQueue<P extends MultimediaPacket> {
        private final int capacity;
        private final int preferredSize;
        private final Queue<P> queue;
        private final Condition hasPacket;
        private volatile boolean discard;

        private PacketQueue(int capacity, int preferredSize) {
            this.hasPacket = PacketReader.this.lock.newCondition();
            this.capacity = capacity;
            this.preferredSize = preferredSize;
            this.queue = new ArrayDeque<P>(capacity);
        }

        public boolean needsPacket() {
            return !this.discard && this.queue.isEmpty();
        }

        public boolean wantsPacket() {
            return !this.discard && this.queue.size() < this.preferredSize;
        }

        public boolean canAcceptPacket() {
            return this.discard || this.queue.size() < this.capacity;
        }

        private void maybeWakeUp() {
            if (PacketReader.this.sleeping && !PacketReader.this.shouldSleep()) {
                PacketReader.this.wakeUp.signal();
            }
        }

        @Nullable
        public P poll() {
            if (this.discard) {
                return null;
            }
            PacketReader.this.lock.lock();
            try {
                MultimediaPacket packet = (MultimediaPacket)this.queue.poll();
                this.maybeWakeUp();
                MultimediaPacket multimediaPacket = packet;
                return (P)multimediaPacket;
            }
            finally {
                PacketReader.this.lock.unlock();
            }
        }

        @Nullable
        public P take() throws InterruptedException {
            if (this.discard) {
                return null;
            }
            PacketReader.this.lock.lock();
            try {
                while (!this.discard) {
                    MultimediaPacket packet = (MultimediaPacket)this.queue.poll();
                    this.maybeWakeUp();
                    if (packet != null || PacketReader.this.closed) {
                        MultimediaPacket multimediaPacket = packet;
                        return (P)multimediaPacket;
                    }
                    this.hasPacket.await();
                }
            }
            finally {
                PacketReader.this.lock.unlock();
            }
            return null;
        }

        public boolean enqueue(P packet) {
            if (this.discard) {
                packet.close();
                return false;
            }
            PacketReader.this.lock.lock();
            try {
                this.queue.add(packet);
                this.hasPacket.signal();
                boolean bl = true;
                return bl;
            }
            finally {
                PacketReader.this.lock.unlock();
            }
        }

        public void discard() {
            PacketReader.this.lock.lock();
            try {
                MultimediaPacket packet;
                this.discard = true;
                while ((packet = (MultimediaPacket)this.queue.poll()) != null) {
                    packet.close();
                }
                this.hasPacket.signal();
            }
            finally {
                PacketReader.this.lock.unlock();
            }
        }

        public void clear() {
            PacketReader.this.lock.lock();
            try {
                this.queue.clear();
            }
            finally {
                PacketReader.this.lock.unlock();
            }
        }
    }

    private record SeekRequest(double time, CompletableFuture<Void> future) {
    }
}

