/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.playback;

import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import org.lovetropics.multimedia.AudioDecoder;
import org.lovetropics.multimedia.DecoderException;
import org.lovetropics.multimedia.MultimediaReader;
import org.lovetropics.multimedia.VideoDecoder;
import org.lovetropics.multimedia.mod.PlaybackClock;
import org.lovetropics.multimedia.mod.client.playback.AudioPlaybackChannel;
import org.lovetropics.multimedia.mod.client.playback.AudioWorldSource;
import org.lovetropics.multimedia.mod.client.playback.FrameSize;
import org.lovetropics.multimedia.mod.client.playback.PacketReader;
import org.lovetropics.multimedia.mod.client.playback.PlaybackManager;
import org.lovetropics.multimedia.mod.client.playback.PlaybackSyncType;
import org.lovetropics.multimedia.mod.client.playback.PlaybackVideoDecoder;
import org.lovetropics.multimedia.mod.client.playback.PresentableVideoFrame;
import org.lovetropics.multimedia.mod.client.playback.VideoFrameTexture;
import org.lovetropics.multimedia.mod.client.playback.VideoFrameUploader;
import org.slf4j.Logger;

public class Playback
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Thread.Builder IO_THREAD_BUILDER = Thread.ofPlatform().name("video-io-", 0L).daemon(true);
    static final Thread.Builder VIDEO_DECODER_THREAD_BUILDER = Thread.ofPlatform().name("video-decoder-", 0L).daemon(true);
    private static final AudioFormat MONO_AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 1, true, false);
    private final FrameSize sourceFrameSize;
    private final double sourceDuration;
    private final PlaybackClock clock;
    private final PacketReader packetReader;
    private final PlaybackVideoDecoder videoDecoder;
    private final VideoFrameUploader videoFrameUploader;
    @Nullable
    private final AudioPlaybackChannel.Handle audioPlayback;
    private final VideoFrameTexture texture;
    private final ReentrantLock seekLock = new ReentrantLock();
    private int seekCount;

    private Playback(MultimediaReader reader, VideoDecoder videoDecoder, @Nullable AudioDecoder audioDecoder, @Nullable FrameSize windowSize, PlaybackSyncType syncType) {
        this.sourceFrameSize = new FrameSize(videoDecoder.width(), videoDecoder.height());
        this.sourceDuration = reader.duration();
        this.clock = new PlaybackClock();
        this.packetReader = new PacketReader(reader);
        this.videoFrameUploader = new VideoFrameUploader(RenderSystem.getDevice(), this.fitTextureSize(windowSize), this.clock.createSyncer(false));
        this.videoDecoder = new PlaybackVideoDecoder(this.packetReader, videoDecoder, this.videoFrameUploader);
        this.audioPlayback = audioDecoder != null ? AudioPlaybackChannel.create(Minecraft.getInstance().getSoundManager(), this.packetReader, audioDecoder, syncType.createAudioSyncer(this.clock)) : null;
        this.texture = VideoFrameTexture.register(Minecraft.getInstance().getTextureManager());
        PlaybackManager.register(this);
    }

    public static Playback open(MultimediaReader reader, @Nullable FrameSize windowSize, PlaybackSyncType syncType) throws IOException, DecoderException {
        VideoDecoder videoDecoder = reader.openVideoDecoder();
        if (videoDecoder == null) {
            throw new IOException("Media has no video stream");
        }
        AudioDecoder audioDecoder = reader.openAudioDecoder(MONO_AUDIO_FORMAT);
        return new Playback(reader, videoDecoder, audioDecoder, windowSize, syncType);
    }

    private FrameSize fitTextureSize(@Nullable FrameSize windowSize) {
        if (windowSize == null) {
            return this.sourceFrameSize;
        }
        FrameSize frameSize = this.sourceFrameSize.fitInto(windowSize);
        if (frameSize.width() > 128) {
            return frameSize.resizeWidth(frameSize.width() & 0xFFFFFFE0);
        }
        return frameSize;
    }

    public void updateWindowSize(@Nullable FrameSize windowSize) {
        this.videoFrameUploader.requestFrameSize(this.fitTextureSize(windowSize));
    }

    public void setAudioVolume(float volume) {
        if (this.audioPlayback != null) {
            this.audioPlayback.setVolume(volume);
        }
    }

    public void setAudioSource(AudioWorldSource source) {
        if (this.audioPlayback != null) {
            this.audioPlayback.setWorldSource(source);
        }
    }

    public void play() {
        this.clock.play();
    }

    public void pause() {
        this.clock.pause();
    }

    public void seekTo(double time) {
        if (Mth.equal((double)time, (double)this.clock.getElapsedTime())) {
            return;
        }
        if (!this.clock.isPaused() && Math.abs(time - this.clock.getElapsedTime()) < 0.5) {
            this.clock.setElapsedTime(time);
            return;
        }
        this.beginSeek();
        this.clock.setElapsedTime(time);
        this.packetReader.seekTo(Mth.clamp((double)time, (double)0.0, (double)this.sourceDuration)).whenComplete((unused, throwable) -> {
            this.endSeek();
            if (throwable != null) {
                LOGGER.error("An error occurred while seeking to {}", (Object)time, throwable);
            }
        });
    }

    private void beginSeek() {
        this.seekLock.lock();
        try {
            if (this.seekCount++ == 0) {
                this.videoFrameUploader.beginSeek();
                if (this.audioPlayback != null) {
                    this.audioPlayback.beginSeek();
                }
            }
        }
        finally {
            this.seekLock.unlock();
        }
    }

    private void endSeek() {
        this.seekLock.lock();
        try {
            if (--this.seekCount == 0) {
                this.videoFrameUploader.endSeek();
                if (this.audioPlayback != null) {
                    this.audioPlayback.endSeek();
                }
            }
        }
        finally {
            this.seekLock.unlock();
        }
    }

    public double currentTime() {
        return this.clock.getElapsedTime();
    }

    public double duration() {
        return this.sourceDuration;
    }

    @Nullable
    public VideoFrameTexture updateTexture(GpuDevice device) {
        PresentableVideoFrame nextFrame = this.videoFrameUploader.takeNextFrame();
        if (nextFrame != null) {
            try (PresentableVideoFrame presentableVideoFrame = nextFrame;){
                this.texture.copyFrom(device, nextFrame);
            }
        }
        return this.texture.hasFrame() ? this.texture : null;
    }

    void endFrame() {
        this.videoFrameUploader.tick();
    }

    @Override
    public void close() {
        PlaybackManager.unregister(this);
        this.packetReader.close();
        this.videoFrameUploader.close();
        this.videoDecoder.close();
        if (this.audioPlayback != null) {
            this.audioPlayback.close();
        }
        Minecraft.getInstance().getTextureManager().release(this.texture.location());
    }
}

