/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.playback;

import com.mojang.logging.LogUtils;
import org.lovetropics.multimedia.DecoderException;
import org.lovetropics.multimedia.VideoDecoder;
import org.lovetropics.multimedia.VideoFrame;
import org.lovetropics.multimedia.VideoPacket;
import org.lovetropics.multimedia.mod.client.playback.PacketReader;
import org.lovetropics.multimedia.mod.client.playback.Playback;
import org.lovetropics.multimedia.mod.client.playback.VideoFrameUploader;
import org.slf4j.Logger;

class PlaybackVideoDecoder
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PacketReader packets;
    private final VideoDecoder decoder;
    private final VideoFrameUploader uploader;
    private final Thread thread;
    private volatile boolean closed;

    public PlaybackVideoDecoder(PacketReader packets, VideoDecoder decoder, VideoFrameUploader uploader) {
        this.packets = packets;
        this.decoder = decoder;
        this.uploader = uploader;
        this.thread = Playback.VIDEO_DECODER_THREAD_BUILDER.start(this::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run() {
        try {
            while (!this.closed) {
                VideoFrame frame = this.decoder.readFrame();
                if (frame == null) {
                    VideoPacket packet = this.packets.takeVideoPacket();
                    if (packet == null) {
                        return;
                    }
                    VideoPacket videoPacket = packet;
                    try {
                        this.decoder.sendPacket(packet);
                        continue;
                    }
                    finally {
                        if (videoPacket == null) continue;
                        videoPacket.close();
                        continue;
                    }
                }
                this.uploader.writeFrame(frame);
            }
            return;
        }
        catch (DecoderException e) {
            LOGGER.error("Failed to read from video stream", (Throwable)e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        finally {
            this.packets.discardVideo();
            this.closed = true;
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.thread.interrupt();
    }
}

