/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.playback;

import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.lovetropics.multimedia.mod.MultimediaMod;
import org.lovetropics.multimedia.mod.client.playback.FrameSize;
import org.lovetropics.multimedia.mod.client.playback.PresentableVideoFrame;

public class VideoFrameTexture
extends AbstractTexture {
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    private final ResourceLocation location;
    @Nullable
    private FrameSize frameSize;

    private VideoFrameTexture(ResourceLocation location) {
        this.location = location;
    }

    static VideoFrameTexture register(TextureManager textureManager) {
        ResourceLocation location = MultimediaMod.location("video_frame_" + NEXT_ID.getAndIncrement());
        VideoFrameTexture texture = new VideoFrameTexture(location);
        textureManager.register(texture.location(), (AbstractTexture)texture);
        return texture;
    }

    private GpuTexture prepareTexture(GpuDevice device, FrameSize frameSize) {
        if (this.texture != null && this.texture.getWidth(0) == frameSize.width() && this.texture.getHeight(0) == frameSize.height()) {
            return this.texture;
        }
        if (this.texture != null) {
            this.texture.close();
        }
        if (this.textureView != null) {
            this.textureView.close();
        }
        this.texture = device.createTexture("Video", 5, TextureFormat.RGBA8, frameSize.width(), frameSize.height(), 1, 1);
        this.texture.setTextureFilter(FilterMode.LINEAR, false);
        this.textureView = device.createTextureView(this.texture);
        return this.texture;
    }

    public void copyFrom(GpuDevice device, PresentableVideoFrame frame) {
        try (PresentableVideoFrame presentableVideoFrame = frame;){
            this.frameSize = frame.frameSize();
            GpuTexture texture = this.prepareTexture(device, this.frameSize);
            frame.copyTo(texture);
        }
    }

    public boolean hasFrame() {
        return this.texture != null;
    }

    public FrameSize frameSize() {
        return Objects.requireNonNull(this.frameSize, "No frame present");
    }

    public ResourceLocation location() {
        return this.location;
    }
}

