/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.slideshow;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.lovetropics.multimedia.mod.MultimediaMod;
import org.lovetropics.multimedia.mod.client.cache.MediaFileCache;
import org.lovetropics.multimedia.mod.client.entity.ScreenClientState;
import org.lovetropics.multimedia.mod.client.playback.PlaybackSyncType;
import org.lovetropics.multimedia.mod.client.slideshow.FullScreenSlideshow;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowDriver;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowGraphics;
import org.lovetropics.multimedia.mod.entity.ScreenEntity;
import org.lovetropics.multimedia.mod.network.SlideshowNetworkId;
import org.lovetropics.multimedia.mod.slideshow.Slideshow;

public class ClientSlideshowManager {
    private final MediaFileCache mediaCache;
    @Nullable
    private FullScreenSlideshow fullScreenSlideshow;
    private final Int2ObjectMap<ScreenClientState> screenStates = new Int2ObjectOpenHashMap();

    public ClientSlideshowManager(MediaFileCache mediaCache) {
        this.mediaCache = mediaCache;
    }

    public void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerAboveAll(MultimediaMod.location("slideshow"), (graphics, deltaTracker) -> {
            Minecraft minecraft = Minecraft.getInstance();
            if (this.fullScreenSlideshow != null && !this.fullScreenSlideshow.shouldRenderOver(minecraft.screen)) {
                float partialTicks = deltaTracker.getGameTimeDeltaPartialTick(true);
                this.fullScreenSlideshow.draw(SlideshowGraphics.forGui(graphics, minecraft.font), partialTicks);
            }
        });
    }

    @SubscribeEvent
    public void onRenderScreen(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (screen != Minecraft.getInstance().screen) {
            return;
        }
        if (this.fullScreenSlideshow != null && this.fullScreenSlideshow.shouldRenderOver(screen)) {
            this.fullScreenSlideshow.draw(SlideshowGraphics.forGui(event.getGuiGraphics(), event.getScreen().getFont()), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public void tick(ClientTickEvent.Pre event) {
        ClientLevel level;
        if (this.fullScreenSlideshow != null && this.fullScreenSlideshow.tick()) {
            this.fullScreenSlideshow.close();
            this.fullScreenSlideshow = null;
        }
        if ((level = Minecraft.getInstance().level) != null) {
            for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(this.screenStates)) {
                Entity entity = level.getEntity(entry.getIntKey());
                if (!(entity instanceof ScreenEntity)) continue;
                ScreenEntity screen = (ScreenEntity)entity;
                ((ScreenClientState)entry.getValue()).tick(screen);
            }
        }
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        if (this.fullScreenSlideshow != null) {
            this.fullScreenSlideshow.close();
            this.fullScreenSlideshow = null;
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().isClientSide() && (entity = event.getEntity()) instanceof ScreenEntity) {
            ScreenEntity screen = (ScreenEntity)entity;
            this.screenStates.put(screen.getId(), (Object)new ScreenClientState());
        }
    }

    @SubscribeEvent
    public void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        ScreenEntity screen;
        ScreenClientState screenState;
        Entity entity;
        if (event.getLevel().isClientSide() && (entity = event.getEntity()) instanceof ScreenEntity && (screenState = (ScreenClientState)this.screenStates.remove((screen = (ScreenEntity)entity).getId())) != null) {
            screenState.close();
        }
    }

    @SubscribeEvent
    public void onLevelUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            this.screenStates.values().forEach(ScreenClientState::close);
            this.screenStates.clear();
        }
    }

    public void start(SlideshowNetworkId id, Slideshow slideshow, double time, boolean paused) {
        slideshow.ensureDownloaded(this.mediaCache);
        ScreenClientState screen = this.getScreenState(id);
        if (screen != null) {
            screen.start(this.mediaCache, slideshow, time, paused);
        } else if (id.isFullScreen()) {
            if (this.fullScreenSlideshow != null) {
                this.fullScreenSlideshow.close();
            }
            this.fullScreenSlideshow = new FullScreenSlideshow(new SlideshowDriver(this.mediaCache, slideshow, PlaybackSyncType.PLAYBACK));
            this.fullScreenSlideshow.seekTo(time, paused);
        }
    }

    public void clear(SlideshowNetworkId id) {
        ScreenClientState screen = this.getScreenState(id);
        if (screen != null) {
            screen.clear();
        } else if (this.fullScreenSlideshow != null) {
            this.fullScreenSlideshow.close();
            this.fullScreenSlideshow = null;
        }
    }

    public void seekTo(SlideshowNetworkId id, double time, boolean paused) {
        ScreenClientState screen = this.getScreenState(id);
        if (screen != null) {
            screen.seekTo(time, paused);
        } else if (id.isFullScreen() && this.fullScreenSlideshow != null) {
            this.fullScreenSlideshow.seekTo(time, paused);
        }
    }

    @Nullable
    private ScreenClientState getScreenState(SlideshowNetworkId id) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || id.isFullScreen()) {
            return null;
        }
        return (ScreenClientState)this.screenStates.get(id.id());
    }

    @Nullable
    public ScreenClientState getScreenState(ScreenEntity screen) {
        return (ScreenClientState)this.screenStates.get(screen.getId());
    }
}

