/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.slideshow;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.Nullable;
import org.lovetropics.multimedia.mod.client.config.MultimediaClientConfig;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowDriver;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowGraphics;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowRenderState;

public class FullScreenSlideshow
implements AutoCloseable {
    private final SlideshowDriver slideshow;
    private boolean closed;

    public FullScreenSlideshow(SlideshowDriver slideshow) {
        this.slideshow = slideshow;
    }

    public boolean tick() {
        if (this.closed) {
            return true;
        }
        this.slideshow.setAudioVolume((float)MultimediaClientConfig.get().audioVolume.getAsDouble());
        if (this.slideshow.tick()) {
            this.closed = true;
            return true;
        }
        if (this.slideshow.hasFadedIn()) {
            this.openScreen();
        }
        return false;
    }

    public void draw(SlideshowGraphics graphics, float partialTicks) {
        SlideshowRenderState state = this.slideshow.extractRenderState(partialTicks);
        if (state == null) {
            return;
        }
        float fade = state.fade();
        float backgroundAlpha = state.currentSlide() != null && state.nextSlide() != null ? 1.0f : (state.currentSlide() != null ? 1.0f - fade : fade);
        graphics.fill(0, 0, graphics.width(), graphics.height(), ARGB.color((float)backgroundAlpha, (int)-16777216));
        state.draw(graphics);
    }

    private void openScreen() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen == null) {
            minecraft.setScreen((Screen)new CaptureScreen());
        }
    }

    public void seekTo(double time, boolean paused) {
        this.slideshow.seekTo(time, paused);
    }

    public boolean shouldRenderOver(@Nullable Screen screen) {
        return screen instanceof ProgressScreen || screen instanceof ReceivingLevelScreen || screen instanceof LevelLoadingScreen;
    }

    @Override
    public void close() {
        this.slideshow.close();
    }

    private class CaptureScreen
    extends Screen {
        public CaptureScreen() {
            super(CommonComponents.EMPTY);
        }

        public void tick() {
            super.tick();
            if (FullScreenSlideshow.this.closed) {
                this.onClose();
            }
        }

        public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        }

        private void openChatScreen(String defaultText) {
            Minecraft.ChatStatus chatStatus = this.minecraft.getChatStatus();
            if (!chatStatus.isChatAllowed(this.minecraft.isLocalServer())) {
                Component component = chatStatus.getMessage();
                this.minecraft.gui.setOverlayMessage(component, false);
                this.minecraft.getNarrator().saySystemNow(component);
                this.minecraft.gui.setChatDisabledByPlayerShown(chatStatus == Minecraft.ChatStatus.DISABLED_BY_PROFILE);
            } else {
                this.minecraft.pushGuiLayer((Screen)new ChatScreen(defaultText));
            }
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 256) {
                this.minecraft.pushGuiLayer((Screen)new PauseScreen(true));
                return true;
            }
            if (this.minecraft.options.keyChat.matches(keyCode, scanCode)) {
                this.openChatScreen("");
                return true;
            }
            if (this.minecraft.options.keyCommand.matches(keyCode, scanCode)) {
                this.openChatScreen("/");
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean isPauseScreen() {
            return false;
        }
    }
}

