/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.slideshow;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.Closeable;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.apache.commons.io.IOUtils;
import org.lovetropics.multimedia.DecoderException;
import org.lovetropics.multimedia.MultimediaReader;
import org.lovetropics.multimedia.mod.MediaFile;
import org.lovetropics.multimedia.mod.MultimediaMod;
import org.lovetropics.multimedia.mod.client.cache.MediaFileCache;
import org.lovetropics.multimedia.mod.client.playback.AudioWorldSource;
import org.lovetropics.multimedia.mod.client.playback.FrameSize;
import org.lovetropics.multimedia.mod.client.playback.Playback;
import org.lovetropics.multimedia.mod.client.playback.PlaybackSyncType;
import org.lovetropics.multimedia.mod.client.playback.VideoFrameTexture;
import org.lovetropics.multimedia.mod.client.slideshow.PreparedSlideDecorations;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowGraphics;
import org.lovetropics.multimedia.mod.slideshow.SlideContent;
import org.lovetropics.multimedia.mod.slideshow.SlideDecorations;

public interface PreparedSlide
extends AutoCloseable {
    private static CompletableFuture<MultimediaReader> openReaderAsync(MediaFileCache mediaCache, MediaFile file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return mediaCache.openMultimediaReader(file);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }, (Executor)Util.nonCriticalIoPool());
    }

    private static CompletableFuture<NativeImage> openImageAsync(MediaFileCache mediaCache, MediaFile file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return mediaCache.loadImage(file);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }, (Executor)Util.nonCriticalIoPool());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompletableFuture<PreparedSlide> tryPrepare(SlideContent content, MediaFileCache mediaCache, PlaybackSyncType syncType) {
        CompletionStage<PreparedSlide> completionStage;
        SlideContent slideContent = content;
        Objects.requireNonNull(slideContent);
        SlideContent slideContent2 = slideContent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SlideContent.Video.class, SlideContent.Image.class, SlideContent.Blank.class}, (Object)slideContent2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                SlideContent.Video video = (SlideContent.Video)slideContent2;
                try {
                    float f;
                    Object object = video.file();
                    MediaFile file = object;
                    Object startAt = object = video.startAt();
                    Object ignored = object = video.duration();
                    float volume = f = video.volume();
                    completionStage = PreparedSlide.openReaderAsync(mediaCache, file).thenApplyAsync(arg_0 -> PreparedSlide.lambda$tryPrepare$2(syncType, (Duration)startAt, volume, arg_0), (Executor)Minecraft.getInstance());
                    return completionStage;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                SlideContent.Image image = (SlideContent.Image)slideContent2;
                {
                    Object object = image.file();
                    MediaFile file = object;
                    object = image.decorations();
                    Record decorations = object;
                    Object ignored = object = image.duration();
                    completionStage = PreparedSlide.openImageAsync(mediaCache, file).thenApplyAsync(arg_0 -> PreparedSlide.lambda$tryPrepare$3((SlideDecorations)decorations, arg_0), (Executor)Minecraft.getInstance());
                    return completionStage;
                }
            }
            case 2: 
        }
        SlideContent.Blank blank = (SlideContent.Blank)slideContent2;
        completionStage = CompletableFuture.completedFuture(new Blank(PreparedSlideDecorations.prepare(blank.decorations())));
        return completionStage;
    }

    private static Video openPlayback(PlaybackSyncType syncType, Duration startAt, float volume, MultimediaReader reader) {
        try {
            Playback playback = Playback.open(reader, null, syncType);
            double startAtTime = (double)startAt.toMillis() / 1000.0;
            playback.seekTo(startAtTime);
            return new Video(playback, startAtTime, volume);
        }
        catch (IOException | DecoderException e) {
            IOUtils.closeQuietly((Closeable)reader);
            throw new CompletionException(e);
        }
    }

    private static Image uploadImage(NativeImage image, SlideDecorations decorations) {
        DynamicTexture texture = new DynamicTexture(() -> "Image slide", image);
        FrameSize imageSize = new FrameSize(image.getWidth(), image.getHeight());
        texture.setPixels(null);
        ResourceLocation textureId = MultimediaMod.location("image_slide_" + Image.NEXT_ID.getAndIncrement());
        Minecraft.getInstance().getTextureManager().register(textureId, (AbstractTexture)texture);
        return new Image(textureId, texture, imageSize, PreparedSlideDecorations.prepare(decorations));
    }

    public void startOrSync(double var1, boolean var3);

    public double getPlaybackTime();

    public void draw(SlideshowGraphics var1, float var2);

    @Override
    public void close();

    default public void setAudioVolume(float volume) {
    }

    default public void setAudioSource(AudioWorldSource source) {
    }

    private static /* synthetic */ PreparedSlide lambda$tryPrepare$3(SlideDecorations decorations, NativeImage image) {
        return PreparedSlide.uploadImage(image, decorations);
    }

    private static /* synthetic */ PreparedSlide lambda$tryPrepare$2(PlaybackSyncType syncType, Duration startAt, float volume, MultimediaReader reader) {
        return PreparedSlide.openPlayback(syncType, startAt, volume, reader);
    }

    public record Blank(PreparedSlideDecorations decorations) implements PreparedSlide
    {
        @Override
        public void startOrSync(double time, boolean paused) {
        }

        @Override
        public double getPlaybackTime() {
            return Double.NaN;
        }

        @Override
        public void draw(SlideshowGraphics graphics, float alpha) {
            this.decorations.draw(graphics, false, alpha);
        }

        @Override
        public void close() {
        }
    }

    public record Video(Playback playback, double startAt, float volume) implements PreparedSlide
    {
        @Override
        public void startOrSync(double time, boolean paused) {
            this.playback.pause();
            this.playback.seekTo(Mth.clamp((double)(time + this.startAt), (double)0.0, (double)this.playback.duration()));
            if (!paused) {
                this.playback.play();
            }
        }

        @Override
        public double getPlaybackTime() {
            return this.playback.currentTime() - this.startAt;
        }

        @Override
        public void draw(SlideshowGraphics graphics, float alpha) {
            this.playback.updateWindowSize(graphics.textureFrameSize());
            VideoFrameTexture texture = this.playback.updateTexture(RenderSystem.getDevice());
            if (texture == null) {
                return;
            }
            FrameSize guiSize = texture.frameSize().resizeInto(graphics.frameSize());
            int x = (graphics.width() - guiSize.width()) / 2;
            int y = (graphics.height() - guiSize.height()) / 2;
            graphics.blit(texture.location(), x, y, guiSize.width(), guiSize.height(), ARGB.white((float)alpha));
        }

        @Override
        public void close() {
            this.playback.close();
        }

        @Override
        public void setAudioVolume(float volume) {
            this.playback.setAudioVolume(volume * this.volume);
        }

        @Override
        public void setAudioSource(AudioWorldSource source) {
            this.playback.setAudioSource(source);
        }
    }

    public record Image(ResourceLocation textureId, DynamicTexture texture, FrameSize imageSize, PreparedSlideDecorations decorations) implements PreparedSlide
    {
        private static final AtomicInteger NEXT_ID = new AtomicInteger();

        @Override
        public void startOrSync(double time, boolean paused) {
        }

        @Override
        public double getPlaybackTime() {
            return Double.NaN;
        }

        @Override
        public void draw(SlideshowGraphics graphics, float alpha) {
            FrameSize guiSize = this.imageSize.resizeInto(graphics.frameSize());
            int x = (graphics.width() - guiSize.width()) / 2;
            int y = (graphics.height() - guiSize.height()) / 2;
            graphics.blit(this.textureId, x, y, guiSize.width(), guiSize.height(), ARGB.white((float)alpha));
            this.decorations.draw(graphics, true, alpha);
        }

        @Override
        public void close() {
            Minecraft.getInstance().getTextureManager().release(this.textureId);
        }
    }
}

