/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.slideshow;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowGraphics;
import org.lovetropics.multimedia.mod.slideshow.SlideDecorations;

public record PreparedSlideDecorations(Component header, List<TextAndWidth> body, int bodyWidth, int lineHeight) {
    private static final int MAX_BODY_WIDTH = 260;
    private static final int BODY_BACKGROUND_PADDING = 4;
    private static final int BODY_BACKGROUND_COLOR = ARGB.color((float)0.8f, (int)-16777216);

    public static PreparedSlideDecorations prepare(SlideDecorations decorations) {
        Font font = Minecraft.getInstance().font;
        List<TextAndWidth> body = PreparedSlideDecorations.splitLines(font, decorations.body(), 260);
        int bodyWidth = 0;
        for (TextAndWidth line : body) {
            bodyWidth = Math.max(bodyWidth, line.width);
        }
        Component component = decorations.header();
        Objects.requireNonNull(font);
        return new PreparedSlideDecorations(component, body, bodyWidth, 9);
    }

    private static List<TextAndWidth> splitLines(Font font, Component message, int maxWidth) {
        return font.splitIgnoringLanguage((FormattedText)message, maxWidth).stream().map(line -> {
            FormattedCharSequence charSequence = Language.getInstance().getVisualOrder(line);
            return new TextAndWidth(charSequence, font.width(charSequence));
        }).toList();
    }

    public void draw(SlideshowGraphics graphics, boolean textBackground, float alpha) {
        int textColor = ARGB.white((float)alpha);
        int centerX = graphics.width() / 2;
        int bodyHeight = this.body.size() * this.lineHeight;
        int bodyTop = (graphics.height() - bodyHeight) / 2;
        int bodyLeft = centerX - this.bodyWidth / 2;
        int headerTop = bodyTop - 4 - this.lineHeight * 2;
        graphics.drawCenteredText(this.header, centerX, headerTop, textColor, 2);
        if (!this.body.isEmpty()) {
            if (textBackground) {
                graphics.fill(bodyLeft - 4, bodyTop - 4, this.bodyWidth + 8, bodyHeight + 8, ARGB.multiply((int)BODY_BACKGROUND_COLOR, (int)ARGB.white((float)alpha)));
            }
            int lineTop = bodyTop;
            for (TextAndWidth line : this.body) {
                graphics.drawText(line.text, centerX - line.width / 2, lineTop, textColor, 1);
                lineTop += this.lineHeight;
            }
        }
    }

    private record TextAndWidth(FormattedCharSequence text, int width) {
    }
}

