/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.slideshow;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.lovetropics.multimedia.mod.client.cache.MediaFileCache;
import org.lovetropics.multimedia.mod.client.playback.PlaybackSyncType;
import org.lovetropics.multimedia.mod.client.slideshow.PreparedSlide;
import org.lovetropics.multimedia.mod.client.slideshow.PreparedSlideDecorations;
import org.lovetropics.multimedia.mod.slideshow.Slide;
import org.lovetropics.multimedia.mod.slideshow.SlideContent;
import org.lovetropics.multimedia.mod.slideshow.SlideDecorations;
import org.lovetropics.multimedia.mod.slideshow.SlideTransition;
import org.lovetropics.multimedia.mod.slideshow.Slideshow;
import org.slf4j.Logger;

public class SlideQueue {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component ERROR_MESSAGE = Component.translatable((String)"slideshow.slide.error").withStyle(ChatFormatting.RED);
    private static final SlideDecorations ERROR_DECORATIONS = new SlideDecorations(CommonComponents.EMPTY, ERROR_MESSAGE);
    private final MediaFileCache mediaCache;
    private final List<SlideContent> slides;
    private final DoubleList slideStartTimes;
    private final DoubleList transitions;
    private final boolean looping;

    private SlideQueue(MediaFileCache mediaCache, List<SlideContent> slides, DoubleList slideStartTimes, DoubleList transitions, boolean looping) {
        this.mediaCache = mediaCache;
        this.slides = slides;
        this.slideStartTimes = slideStartTimes;
        this.transitions = transitions;
        this.looping = looping;
    }

    public static SlideQueue load(MediaFileCache mediaCache, Slideshow slideshow) {
        ArrayList<SlideContent> slides = new ArrayList<SlideContent>(slideshow.slides().size());
        DoubleArrayList slideStartTimes = new DoubleArrayList(slideshow.slides().size() + 1);
        DoubleArrayList transitions = new DoubleArrayList(slideshow.slides().size() + 1);
        double slideStartTime = 0.0;
        SlideTransition lastTransition = slideshow.defaultTransition();
        for (Slide slide : slideshow.slides()) {
            SlideTransition transitionIn = slide.transitionIn().orElse(lastTransition);
            double duration = SlideQueue.toSeconds(slide.content().duration());
            double transitionInDuration = Math.min(SlideQueue.toSeconds(transitionIn.duration()), duration);
            double slideEndTime = slideStartTime + duration;
            slides.add(slide.content());
            slideStartTimes.add(slideStartTime);
            transitions.add(transitionInDuration);
            slideStartTime = slideEndTime;
            lastTransition = slide.transitionOut().orElse(slideshow.defaultTransition());
        }
        slideStartTimes.add(slideStartTime);
        transitions.add(SlideQueue.toSeconds(lastTransition.duration()));
        return new SlideQueue(mediaCache, slides, (DoubleList)slideStartTimes, (DoubleList)transitions, slideshow.looping());
    }

    public int getSlideIndexAt(double time) {
        int baseIndex;
        if (this.looping) {
            double totalDuration = this.getTotalDuration();
            int loopCount = Mth.floor((double)(time / totalDuration));
            baseIndex = loopCount * this.slides.size();
            time -= (double)loopCount * totalDuration;
        } else {
            baseIndex = 0;
        }
        for (int i = 0; i < this.slides.size(); ++i) {
            if (!(time < this.getSlideEndTime(i))) continue;
            return baseIndex + i;
        }
        return baseIndex + this.slides.size();
    }

    public double getSlideStartTime(int index) {
        double baseTime;
        if (this.looping) {
            int loopCount = Mth.floorDiv((int)index, (int)this.slides.size());
            baseTime = (double)loopCount * this.getTotalDuration();
            index -= loopCount * this.slides.size();
        } else {
            baseTime = 0.0;
        }
        return this.slideStartTimes.getDouble(index) + baseTime;
    }

    public double getSlideEndTime(int index) {
        double baseTime;
        if (this.looping) {
            int loopCount = Mth.floorDiv((int)index, (int)this.slides.size());
            baseTime = (double)loopCount * this.getTotalDuration();
            index -= loopCount * this.slides.size();
        } else {
            baseTime = 0.0;
        }
        return this.slideStartTimes.getDouble(index + 1) + baseTime;
    }

    public double getTransitionIn(int index) {
        if (this.looping) {
            index = Math.floorMod(index, this.slides.size());
        }
        return this.transitions.getDouble(index);
    }

    public double getTotalDuration() {
        return this.slideStartTimes.getDouble(this.slides.size());
    }

    public int size() {
        return this.slides.size();
    }

    public CompletableFuture<PreparedSlide> prepareSlide(int index, PlaybackSyncType syncType) {
        if (this.looping) {
            index = Math.floorMod(index, this.slides.size());
        }
        SlideContent content = this.slides.get(index);
        return PreparedSlide.tryPrepare(content, this.mediaCache, syncType).exceptionally(throwable -> {
            LOGGER.error("Failed to load slide {}", (Object)content, throwable);
            return new PreparedSlide.Blank(PreparedSlideDecorations.prepare(ERROR_DECORATIONS));
        });
    }

    private static double toSeconds(Duration duration) {
        return (double)duration.toMillis() / 1000.0;
    }
}

