/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.slideshow;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import org.lovetropics.multimedia.mod.PlaybackClock;
import org.lovetropics.multimedia.mod.client.cache.MediaFileCache;
import org.lovetropics.multimedia.mod.client.playback.AudioWorldSource;
import org.lovetropics.multimedia.mod.client.playback.PlaybackSyncType;
import org.lovetropics.multimedia.mod.client.slideshow.PreparedSlide;
import org.lovetropics.multimedia.mod.client.slideshow.SlideQueue;
import org.lovetropics.multimedia.mod.client.slideshow.SlideshowRenderState;
import org.lovetropics.multimedia.mod.slideshow.Slideshow;

public class SlideshowDriver
implements AutoCloseable {
    private static final double PREPARE_TIME_MARGIN = 5.0;
    private final Slideshow slideshow;
    private final PlaybackSyncType syncType;
    private final SlideQueue slideQueue;
    private final PlaybackClock clock = new PlaybackClock();
    private float audioVolume = 1.0f;
    @Nullable
    private AudioWorldSource audioSource;
    @Nullable
    private State state;

    public SlideshowDriver(MediaFileCache mediaCache, Slideshow slideshow, PlaybackSyncType syncType) {
        this.slideshow = slideshow;
        this.slideQueue = SlideQueue.load(mediaCache, slideshow);
        this.syncType = syncType;
    }

    public void setAudioVolume(float volume) {
        if (volume == this.audioVolume) {
            return;
        }
        this.audioVolume = volume;
        if (this.state != null) {
            this.state.updateAudio();
        }
    }

    public void setAudioSource(AudioWorldSource source) {
        if (source.equals(this.audioSource)) {
            return;
        }
        this.audioSource = source;
        if (this.state != null) {
            this.state.updateAudio();
        }
    }

    public void seekTo(double time, boolean paused) {
        Slide currentSlide;
        this.clock.set(time, paused);
        if (this.state != null && this.state.trySeek(this.clock)) {
            return;
        }
        int index = this.slideQueue.getSlideIndexAt(time);
        if (this.state != null) {
            this.state.close();
        }
        this.state = time < (currentSlide = this.prepareSlide(index)).startTime() + currentSlide.transitionIn() ? this.startFading(this.prepareSlide(index - 1), currentSlide) : this.startPlaying(currentSlide);
    }

    private Slide prepareSlide(int index) {
        if (index < 0) {
            return new Slide(index, null, 0.0, 0.0, 0.0);
        }
        if (!this.slideshow.looping() && index >= this.slideQueue.size()) {
            double startTime = this.slideQueue.getSlideStartTime(index);
            double transitionIn = this.slideQueue.getTransitionIn(index);
            return new Slide(index, null, startTime, startTime, transitionIn);
        }
        Slide slide = new Slide(index, this.slideQueue.prepareSlide(index, this.syncType), this.slideQueue.getSlideStartTime(index), this.slideQueue.getSlideEndTime(index), this.slideQueue.getTransitionIn(index));
        slide.setAudioVolume(this.audioVolume);
        if (this.audioSource != null) {
            slide.setAudioSource(this.audioSource);
        }
        return slide;
    }

    @Nullable
    private State startPlaying(Slide slide) {
        if (slide.isEmpty()) {
            return null;
        }
        slide.setAudioVolume(this.audioVolume);
        slide.startOrSync(this.clock);
        return new Playing(slide);
    }

    @Nullable
    private State startFading(Slide fromSlide, Slide toSlide) {
        if (fromSlide.isEmpty() && toSlide.isEmpty()) {
            return null;
        }
        fromSlide.startOrSync(this.clock);
        toSlide.setAudioVolume(0.0f);
        toSlide.startOrSync(this.clock);
        return new Fading(fromSlide, toSlide);
    }

    public boolean tick() {
        if (this.state != null) {
            this.syncToPlayback();
            this.state = this.state.tick();
        }
        return this.state == null;
    }

    private void syncToPlayback() {
        if (this.state == null || this.syncType != PlaybackSyncType.PLAYBACK) {
            return;
        }
        double playbackTime = this.state.getPlaybackTime();
        if (!Double.isNaN(playbackTime)) {
            this.clock.setElapsedTime(playbackTime);
        }
    }

    @Nullable
    public SlideshowRenderState extractRenderState(float partialTicks) {
        if (this.state != null) {
            return this.state.extractRenderState(partialTicks);
        }
        return null;
    }

    public boolean hasFadedIn() {
        return this.state != null && this.state.hasFadedIn();
    }

    @Override
    public void close() {
        if (this.state != null) {
            this.state.close();
            this.state = null;
        }
    }

    public Slideshow slideshow() {
        return this.slideshow;
    }

    private static interface State
    extends AutoCloseable {
        @Nullable
        public State tick();

        public boolean trySeek(PlaybackClock var1);

        public void updateAudio();

        public boolean hasFadedIn();

        public double getPlaybackTime();

        @Nullable
        public SlideshowRenderState extractRenderState(float var1);

        @Override
        public void close();
    }

    private record Slide(int index, @Nullable CompletableFuture<PreparedSlide> future, double startTime, double endTime, double transitionIn) implements AutoCloseable
    {
        public boolean isEmpty() {
            return this.future == null;
        }

        @Nullable
        public PreparedSlide getNow() {
            if (this.future == null) {
                return null;
            }
            return this.future.getNow(null);
        }

        private void execute(Consumer<PreparedSlide> handler) {
            if (this.future == null) {
                return;
            }
            if (this.future.isDone()) {
                handler.accept(this.future.join());
            } else {
                this.future.thenAcceptAsync((Consumer)handler, (Executor)Minecraft.getInstance());
            }
        }

        public void startOrSync(PlaybackClock clock) {
            this.execute(slide -> slide.startOrSync(clock.getElapsedTime() - this.startTime, clock.isPaused()));
        }

        public void setAudioVolume(float volume) {
            this.execute(slide -> slide.setAudioVolume(volume));
        }

        public void setAudioSource(AudioWorldSource source) {
            this.execute(slide -> slide.setAudioSource(source));
        }

        public double getPlaybackTime() {
            PreparedSlide slide = this.getNow();
            if (slide == null) {
                return Double.NaN;
            }
            return slide.getPlaybackTime() + this.startTime;
        }

        @Override
        public void close() {
            this.execute(PreparedSlide::close);
        }
    }

    private class Playing
    implements State {
        private final Slide slide;
        @Nullable
        private Slide nextSlide;

        private Playing(Slide slide) {
            this.slide = slide;
        }

        @Override
        @Nullable
        public State tick() {
            double remainingTime = this.slide.endTime() - SlideshowDriver.this.clock.getElapsedTime();
            if (this.nextSlide == null && remainingTime < 5.0) {
                this.nextSlide = SlideshowDriver.this.prepareSlide(this.slide.index() + 1);
            }
            if (remainingTime <= 0.0) {
                return SlideshowDriver.this.startFading(this.slide, this.nextSlide);
            }
            return this;
        }

        @Override
        public boolean trySeek(PlaybackClock clock) {
            double time = clock.getElapsedTime();
            if (time >= this.slide.startTime() && time < this.slide.endTime()) {
                this.slide.startOrSync(clock);
                return true;
            }
            return false;
        }

        @Override
        public void updateAudio() {
            this.slide.setAudioVolume(SlideshowDriver.this.audioVolume);
            if (this.nextSlide != null) {
                this.nextSlide.setAudioVolume(SlideshowDriver.this.audioVolume);
            }
            if (SlideshowDriver.this.audioSource != null) {
                this.slide.setAudioSource(SlideshowDriver.this.audioSource);
                if (this.nextSlide != null) {
                    this.nextSlide.setAudioSource(SlideshowDriver.this.audioSource);
                }
            }
        }

        @Override
        public boolean hasFadedIn() {
            return true;
        }

        @Override
        public double getPlaybackTime() {
            return this.slide.getPlaybackTime();
        }

        @Override
        @Nullable
        public SlideshowRenderState extractRenderState(float partialTicks) {
            return new SlideshowRenderState(this.slide.getNow(), null, 0.0f);
        }

        @Override
        public void close() {
            this.slide.close();
            if (this.nextSlide != null) {
                this.nextSlide.close();
            }
        }
    }

    private class Fading
    implements State {
        private final Slide fromSlide;
        private final Slide toSlide;
        private float lastFade;
        private float fade;

        private Fading(Slide fromSlide, Slide toSlide) {
            this.fromSlide = fromSlide;
            this.toSlide = toSlide;
        }

        @Override
        @Nullable
        public State tick() {
            double elapsedTime = SlideshowDriver.this.clock.getElapsedTime();
            double fromTime = this.toSlide.startTime();
            double toTime = this.toSlide.startTime() + this.toSlide.transitionIn();
            if (elapsedTime >= toTime) {
                this.fromSlide.close();
                return SlideshowDriver.this.startPlaying(this.toSlide);
            }
            this.lastFade = this.fade;
            this.fade = (float)Mth.inverseLerp((double)Mth.clamp((double)elapsedTime, (double)fromTime, (double)toTime), (double)fromTime, (double)toTime);
            this.updateAudio();
            return this;
        }

        @Override
        public boolean trySeek(PlaybackClock clock) {
            return false;
        }

        @Override
        public void updateAudio() {
            this.fromSlide.setAudioVolume(SlideshowDriver.this.audioVolume * (1.0f - this.fade));
            this.toSlide.setAudioVolume(SlideshowDriver.this.audioVolume * this.fade);
            if (SlideshowDriver.this.audioSource != null) {
                this.fromSlide.setAudioSource(SlideshowDriver.this.audioSource);
                this.toSlide.setAudioSource(SlideshowDriver.this.audioSource);
            }
        }

        @Override
        public boolean hasFadedIn() {
            return this.fromSlide.getNow() != null;
        }

        @Override
        public double getPlaybackTime() {
            return this.fromSlide.getPlaybackTime();
        }

        @Override
        public SlideshowRenderState extractRenderState(float partialTicks) {
            return new SlideshowRenderState(this.fromSlide.getNow(), this.toSlide.getNow(), Mth.lerp((float)partialTicks, (float)this.lastFade, (float)this.fade));
        }

        @Override
        public void close() {
            this.fromSlide.close();
            this.toSlide.close();
        }
    }
}

