/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.client.slideshow;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lovetropics.multimedia.mod.client.ScreenSizeCapture;
import org.lovetropics.multimedia.mod.client.playback.FrameSize;

public interface SlideshowGraphics {
    public static final double LOG_2 = Math.log(2.0);
    public static final FrameSize BASE_GUI_SIZE = new FrameSize(320, 240);

    public static float roundLog2(float value) {
        return (float)Math.pow(2.0, Mth.ceil((double)(Math.log(value) / LOG_2)));
    }

    public static SlideshowGraphics forGui(final GuiGraphics graphics, final Font font) {
        final FrameSize frameSize = new FrameSize(graphics.guiWidth(), graphics.guiHeight());
        final FrameSize textureFrameSize = FrameSize.from(Minecraft.getInstance().getWindow());
        return new SlideshowGraphics(){

            @Override
            public FrameSize frameSize() {
                return frameSize;
            }

            @Override
            public FrameSize textureFrameSize() {
                return textureFrameSize;
            }

            @Override
            public void fill(int x, int y, int width, int height, int color) {
                graphics.fill(x, y, x + width, y + height, color);
            }

            @Override
            public void blit(ResourceLocation location, int x, int y, int width, int height, int color) {
                graphics.blit(RenderPipelines.GUI_TEXTURED, location, x, y, 0.0f, 0.0f, width, height, 1, 1, 1, 1, color);
            }

            @Override
            public void drawText(FormattedCharSequence text, int x, int y, int color, int scale) {
                graphics.pose().pushMatrix();
                graphics.pose().translate((float)x, (float)y);
                graphics.pose().scale((float)scale);
                graphics.drawString(font, text, 0, 0, color);
                graphics.pose().popMatrix();
            }

            @Override
            public Font font() {
                return font;
            }
        };
    }

    @Nullable
    public static SlideshowGraphics forWorld(PoseStack.Pose pose, final float worldWidth, final float worldHeight, final int lightCoords, final MultiBufferSource bufferSource, final Font font) {
        final FrameSize frameSize = new FrameSize(Math.round(worldWidth * 16.0f), Math.round(worldHeight * 16.0f)).resizeInto(BASE_GUI_SIZE);
        Vector2fc screenSizePixels = ScreenSizeCapture.sizeInScreenPixels(pose, new Vector3fc[]{new Vector3f(-worldWidth / 2.0f, -worldHeight / 2.0f, 0.0f), new Vector3f(worldWidth / 2.0f, -worldHeight / 2.0f, 0.0f), new Vector3f(worldWidth / 2.0f, worldHeight / 2.0f, 0.0f), new Vector3f(-worldWidth / 2.0f, worldHeight / 2.0f, 0.0f)});
        if (screenSizePixels == null) {
            return null;
        }
        float textureScale = SlideshowGraphics.roundLog2(Math.max(screenSizePixels.x() / (float)frameSize.width(), screenSizePixels.y() / (float)frameSize.height()));
        final FrameSize textureFrameSize = frameSize.scale(textureScale);
        final PoseStack poseStack = new PoseStack();
        poseStack.mulPose((Matrix4fc)pose.pose());
        return new SlideshowGraphics(){
            private static final float Z_OFFSET = 0.001f;

            @Override
            public FrameSize frameSize() {
                return frameSize;
            }

            @Override
            public FrameSize textureFrameSize() {
                return textureFrameSize;
            }

            @Override
            public void fill(int x, int y, int width, int height, int color) {
                this.addQuad(x, y, width, height, color, bufferSource.getBuffer(RenderType.textBackground()));
            }

            @Override
            public void blit(ResourceLocation location, int x, int y, int width, int height, int color) {
                this.addQuad(x, y, width, height, color, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)location)));
            }

            private void addQuad(float x, float y, float width, float height, int color, VertexConsumer buffer) {
                float x0 = -worldWidth / 2.0f + x / (float)frameSize.width() * worldWidth;
                float y0 = -worldHeight / 2.0f + y / (float)frameSize.height() * worldHeight;
                float x1 = x0 + width / (float)frameSize.width() * worldWidth;
                float y1 = y0 + height / (float)frameSize.height() * worldHeight;
                PoseStack.Pose pose = poseStack.last();
                buffer.addVertex(pose, x0, y0, 0.0f).setUv(0.0f, 1.0f).setLight(lightCoords).setNormal(pose, 0.0f, 0.0f, -1.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY);
                buffer.addVertex(pose, x1, y0, 0.0f).setUv(1.0f, 1.0f).setLight(lightCoords).setNormal(pose, 0.0f, 0.0f, -1.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY);
                buffer.addVertex(pose, x1, y1, 0.0f).setUv(1.0f, 0.0f).setLight(lightCoords).setNormal(pose, 0.0f, 0.0f, -1.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY);
                buffer.addVertex(pose, x0, y1, 0.0f).setUv(0.0f, 0.0f).setLight(lightCoords).setNormal(pose, 0.0f, 0.0f, -1.0f).setColor(color).setOverlay(OverlayTexture.NO_OVERLAY);
                poseStack.translate(0.0f, 0.0f, 0.001f);
            }

            @Override
            public void drawText(FormattedCharSequence text, int x, int y, int color, int scale) {
                poseStack.pushPose();
                poseStack.translate(((float)x / (float)frameSize.width() - 0.5f) * worldWidth, (0.5f - (float)y / (float)frameSize.height()) * worldHeight, 0.0f);
                poseStack.scale((float)scale * worldWidth / (float)frameSize.width(), (float)(-scale) * worldHeight / (float)frameSize.height(), 0.0625f);
                font.drawInBatch(text, 0.0f, 0.0f, color, true, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, lightCoords);
                poseStack.popPose();
                poseStack.translate(0.0f, 0.0f, 0.001f);
            }

            @Override
            public Font font() {
                return font;
            }
        };
    }

    default public int width() {
        return this.frameSize().width();
    }

    default public int height() {
        return this.frameSize().height();
    }

    public FrameSize frameSize();

    public FrameSize textureFrameSize();

    public void fill(int var1, int var2, int var3, int var4, int var5);

    public void blit(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6);

    public void drawText(FormattedCharSequence var1, int var2, int var3, int var4, int var5);

    default public void drawCenteredText(Component text, int x, int y, int color, int scale) {
        FormattedCharSequence charSequence = text.getVisualOrderText();
        int n = x - this.font().width(charSequence) * scale / 2;
        Objects.requireNonNull(this.font());
        this.drawText(charSequence, n, y - 9 * scale / 2, color, scale);
    }

    public Font font();
}

