/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.command;

import com.lovetropics.lib.slideshow.SlideshowInstanceHandle;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.lovetropics.multimedia.mod.MultimediaMod;
import org.lovetropics.multimedia.mod.entity.ScreenEntity;
import org.lovetropics.multimedia.mod.slideshow.SlideshowHolder;
import org.lovetropics.multimedia.mod.slideshow.SlideshowRegistry;
import org.lovetropics.multimedia.mod.slideshow.instance.ServerFullScreenSlideshow;

@EventBusSubscriber(modid="multimedia")
public class SlideshowCommand {
    private static final DynamicCommandExceptionType NO_SLIDESHOW = new DynamicCommandExceptionType(id -> Component.translatableEscape((String)"commands.slideshow.error.no_slideshow", (Object[])new Object[]{id}));

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"slideshow").requires((Predicate)Commands.hasPermission((int)2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(((LiteralArgumentBuilder)Commands.literal((String)"play").executes(context -> SlideshowCommand.setSlideshowPaused(EntityArgument.getEntities((CommandContext)context, (String)"targets"), false))).then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(SlideshowRegistry.REGISTRY.keySet(), (SuggestionsBuilder)builder)).executes(context -> SlideshowCommand.startSlideshow(EntityArgument.getEntities((CommandContext)context, (String)"targets"), ResourceLocationArgument.getId((CommandContext)context, (String)"id")))))).then(Commands.literal((String)"pause").executes(context -> SlideshowCommand.setSlideshowPaused(EntityArgument.getEntities((CommandContext)context, (String)"targets"), true)))).then(Commands.literal((String)"seek").then(Commands.argument((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> SlideshowCommand.seekSlideshow(EntityArgument.getEntities((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"seconds")))))).then(Commands.literal((String)"clear").executes(context -> SlideshowCommand.clearSlideshow(EntityArgument.getEntities((CommandContext)context, (String)"targets"))))).then(Commands.literal((String)"preload").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(SlideshowRegistry.REGISTRY.keySet(), (SuggestionsBuilder)builder)).executes(context -> SlideshowCommand.preloadSlideshow(EntityArgument.getEntities((CommandContext)context, (String)"targets"), ResourceLocationArgument.getId((CommandContext)context, (String)"id")))))));
    }

    private static int startSlideshow(Collection<? extends Entity> targets, ResourceLocation id) throws CommandSyntaxException {
        SlideshowHolder slideshow = SlideshowRegistry.REGISTRY.get(id);
        if (slideshow == null) {
            throw NO_SLIDESHOW.create((Object)id);
        }
        for (Entity entity : targets) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ServerFullScreenSlideshow instance = MultimediaMod.slideshowManager().open(slideshow);
                instance.play();
                instance.addPlayer(player);
                continue;
            }
            if (!(entity instanceof ScreenEntity)) continue;
            ScreenEntity screen = (ScreenEntity)entity;
            screen.setSlideshow(slideshow);
        }
        return targets.size();
    }

    private static int clearSlideshow(Collection<? extends Entity> targets) {
        for (Entity entity : targets) {
            MultimediaMod.slideshowManager().clear(entity);
        }
        return targets.size();
    }

    private static int setSlideshowPaused(Collection<? extends Entity> targets, boolean paused) {
        return SlideshowCommand.applyToInstances(targets, instance -> instance.setPaused(paused));
    }

    private static int seekSlideshow(Collection<? extends Entity> targets, double seconds) {
        return SlideshowCommand.applyToInstances(targets, instance -> instance.seekTo(seconds, instance.isPaused()));
    }

    private static int applyToInstances(Collection<? extends Entity> targets, Consumer<SlideshowInstanceHandle> consumer) {
        ReferenceOpenHashSet instances = new ReferenceOpenHashSet();
        for (Entity entity : targets) {
            SlideshowInstanceHandle instance = MultimediaMod.slideshowManager().byEntity(entity);
            if (instance == null) continue;
            instances.add(instance);
        }
        for (SlideshowInstanceHandle slideshowInstanceHandle : instances) {
            consumer.accept(slideshowInstanceHandle);
        }
        return instances.size();
    }

    private static int preloadSlideshow(Collection<? extends Entity> targets, ResourceLocation id) throws CommandSyntaxException {
        SlideshowHolder slideshow = SlideshowRegistry.REGISTRY.get(id);
        if (slideshow == null) {
            throw NO_SLIDESHOW.create((Object)id);
        }
        for (Entity entity : targets) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            MultimediaMod.slideshowManager().preload(player, slideshow);
        }
        return targets.size();
    }
}

