/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.entity;

import com.lovetropics.lib.slideshow.SlideshowInstanceHandle;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.lovetropics.multimedia.mod.MultimediaMod;
import org.lovetropics.multimedia.mod.PlaybackClock;
import org.lovetropics.multimedia.mod.client.playback.AudioWorldSource;
import org.lovetropics.multimedia.mod.network.ClientboundClearSlideshowPacket;
import org.lovetropics.multimedia.mod.network.ClientboundSeekSlideshowPacket;
import org.lovetropics.multimedia.mod.network.ClientboundStartSlideshowPacket;
import org.lovetropics.multimedia.mod.network.SlideshowNetworkId;
import org.lovetropics.multimedia.mod.slideshow.SlideshowHolder;

public class ScreenEntity
extends Entity {
    private static final int PERMISSION_CHECK_INTERVAL = 10;
    public static final float DEFAULT_WIDTH = 4.0f;
    public static final float DEFAULT_HEIGHT = 2.25f;
    public static final float DEFAULT_AUDIO_RADIUS = 64.0f;
    private static final EntityDataAccessor<Float> DATA_WIDTH = SynchedEntityData.defineId(ScreenEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT = SynchedEntityData.defineId(ScreenEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_AUDIO_RADIUS = SynchedEntityData.defineId(ScreenEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final Codec<AABB> AABB_CODEC = Codec.DOUBLE.listOf(6, 6).xmap(coordinates -> new AABB(((Double)coordinates.get(0)).doubleValue(), ((Double)coordinates.get(1)).doubleValue(), ((Double)coordinates.get(2)).doubleValue(), ((Double)coordinates.get(3)).doubleValue(), ((Double)coordinates.get(4)).doubleValue(), ((Double)coordinates.get(5)).doubleValue()), aabb -> List.of(Double.valueOf(aabb.minX), Double.valueOf(aabb.minY), Double.valueOf(aabb.minZ), Double.valueOf(aabb.maxX), Double.valueOf(aabb.maxY), Double.valueOf(aabb.maxZ)));
    @Nullable
    private SlideshowHolder slideshow;
    private final PlaybackClock clock = new PlaybackClock();
    private boolean requiresItemToView;
    @Nullable
    private AABB insideBoxToView;
    @Nullable
    private SlideshowHolder fallbackSlideshow;
    private final Reference2BooleanMap<ServerPlayer> trackingPlayers = new Reference2BooleanOpenHashMap();
    private float lastXRot;
    private float lastYRot;

    public ScreenEntity(EntityType<? extends ScreenEntity> type, Level level) {
        super(type, level);
    }

    private SlideshowNetworkId networkId() {
        return SlideshowNetworkId.of(this);
    }

    public boolean isPermittedToView(ServerPlayer player) {
        if (this.slideshow == null) {
            return true;
        }
        return !(this.requiresItemToView && !this.hasItemToView(player, this.slideshow) || this.insideBoxToView != null && !this.insideBoxToView.contains(player.position()));
    }

    private boolean hasItemToView(ServerPlayer player, SlideshowHolder slideshow) {
        for (EquipmentSlot slot : EquipmentSlot.VALUES) {
            ItemStack itemStack = player.getItemBySlot(slot);
            List slideshows = (List)itemStack.getOrDefault(MultimediaMod.SLIDESHOW_VIEWER, List.of());
            if (!slideshows.contains(slideshow.id()) || !player.isEquippableInSlot(itemStack, slot)) continue;
            return true;
        }
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        boolean permittedToView = this.isPermittedToView(player);
        this.sendSlideshowTo(player, permittedToView, true);
        this.trackingPlayers.put((Object)player, permittedToView);
    }

    private void sendSlideshowTo(ServerPlayer player, boolean permittedToView, boolean initialTrack) {
        SlideshowHolder slideshow;
        SlideshowHolder slideshowHolder = slideshow = permittedToView ? this.slideshow : this.fallbackSlideshow;
        if (slideshow != null) {
            player.connection.send((CustomPacketPayload)new ClientboundStartSlideshowPacket(this.networkId(), slideshow.value(), this.clock.getElapsedTime(), this.clock.isPaused()));
        } else if (!initialTrack) {
            player.connection.send((CustomPacketPayload)new ClientboundClearSlideshowPacket(this.networkId()));
        }
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.trackingPlayers.removeBoolean((Object)serverPlayer);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_WIDTH, (Object)Float.valueOf(4.0f));
        builder.define(DATA_HEIGHT, (Object)Float.valueOf(2.25f));
        builder.define(DATA_AUDIO_RADIUS, (Object)Float.valueOf(64.0f));
    }

    @Nullable
    public SlideshowInstanceHandle asHandle() {
        if (this.slideshow == null) {
            return null;
        }
        final double totalTime = (double)this.slideshow.value().duration().toMillis() / 1000.0;
        return new SlideshowInstanceHandle(){

            public void addPlayer(ServerPlayer player) {
            }

            public void removePlayer(ServerPlayer player) {
            }

            public void seekTo(double time, boolean paused) {
                ScreenEntity.this.seekTo(time, paused);
            }

            public double currentTime() {
                return ScreenEntity.this.clock.getElapsedTime();
            }

            public double totalTime() {
                return totalTime;
            }

            public boolean isPaused() {
                return ScreenEntity.this.clock.isPaused();
            }

            public void close() {
                ScreenEntity.this.setSlideshow(null);
            }
        };
    }

    public void setSlideshow(@Nullable SlideshowHolder slideshow) {
        this.clock.set(0.0, false);
        this.slideshow = slideshow;
        for (Reference2BooleanMap.Entry entry : Reference2BooleanMaps.fastIterable(this.trackingPlayers)) {
            this.sendSlideshowTo((ServerPlayer)entry.getKey(), entry.getBooleanValue(), false);
        }
    }

    private void loadSlideshow(@Nullable SlideshowHolder slideshow, double time, boolean paused) {
        this.slideshow = slideshow;
        if (slideshow != null) {
            this.clock.set(time, paused);
        }
    }

    private void seekTo(double time, boolean paused) {
        if (this.slideshow != null) {
            this.clock.set(time, paused);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientboundSeekSlideshowPacket(this.networkId(), time, paused), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public float getWidth() {
        return ((Float)this.entityData.get(DATA_WIDTH)).floatValue();
    }

    public float getHeight() {
        return ((Float)this.entityData.get(DATA_HEIGHT)).floatValue();
    }

    private float getAudioRadius() {
        return ((Float)this.entityData.get(DATA_AUDIO_RADIUS)).floatValue();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(DATA_WIDTH) || key.equals(DATA_HEIGHT)) {
            this.refreshDimensions();
        }
    }

    public void tick() {
        super.tick();
        if (this.getXRot() != this.lastXRot || this.getYRot() != this.lastYRot) {
            this.refreshDimensions();
            this.lastXRot = this.getXRot();
            this.lastYRot = this.getYRot();
            this.hasImpulse = true;
        }
        if (!this.level().isClientSide() && this.tickCount % 10 == 0) {
            this.checkViewerPermissions();
        }
    }

    private void checkViewerPermissions() {
        for (Reference2BooleanMap.Entry entry : Reference2BooleanMaps.fastIterable(this.trackingPlayers)) {
            boolean isPermittedToView;
            boolean wasPermittedToView = entry.getBooleanValue();
            if (wasPermittedToView == (isPermittedToView = this.isPermittedToView((ServerPlayer)entry.getKey()))) continue;
            this.sendSlideshowTo((ServerPlayer)entry.getKey(), isPermittedToView, false);
            entry.setValue(isPermittedToView);
        }
    }

    public void teleportSetPosition(PositionMoveRotation positionMovementRotation, Set<Relative> relatives) {
        super.teleportSetPosition(positionMovementRotation, relatives);
        this.hasImpulse = true;
    }

    protected AABB makeBoundingBox(Vec3 center) {
        Vec3[] corners = new Vec3[]{new Vec3((double)(-this.getWidth()) / 2.0, (double)(-this.getHeight()) / 2.0, 0.0), new Vec3((double)this.getWidth() / 2.0, (double)(-this.getHeight()) / 2.0, 0.0), new Vec3((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0, 0.0), new Vec3((double)(-this.getWidth()) / 2.0, (double)this.getHeight() / 2.0, 0.0)};
        AABB.Builder box = new AABB.Builder();
        for (Vec3 corner : corners) {
            box.include((Vector3fc)corner.xRot(this.getXRot() * ((float)Math.PI / 180)).yRot(-this.getYRot() * ((float)Math.PI / 180)).toVector3f());
        }
        return box.build().move(center);
    }

    public AudioWorldSource asAudioSource() {
        return new AudioWorldSource.Rectangle(this.position(), (Quaternionfc)new Quaternionf().rotationXYZ(this.getXRot() * ((float)Math.PI / 180), -this.getYRot() * ((float)Math.PI / 180), 0.0f), this.getWidth(), this.getHeight(), this.getAudioRadius());
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        output.putFloat("width", this.getWidth());
        output.putFloat("height", this.getHeight());
        output.putFloat("audio_radius", this.getAudioRadius());
        output.storeNullable("slideshow", SlideshowHolder.CODEC, (Object)this.slideshow);
        if (this.slideshow != null) {
            output.putDouble("time", this.clock.getElapsedTime());
            output.putBoolean("paused", this.clock.isPaused());
        }
        output.storeNullable("fallback_slideshow", SlideshowHolder.CODEC, (Object)this.fallbackSlideshow);
        output.putBoolean("requires_item_to_view", this.requiresItemToView);
        output.storeNullable("inside_box_to_view", AABB_CODEC, (Object)this.insideBoxToView);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        this.entityData.set(DATA_WIDTH, (Object)Float.valueOf(input.getFloatOr("width", 4.0f)));
        this.entityData.set(DATA_HEIGHT, (Object)Float.valueOf(input.getFloatOr("height", 2.25f)));
        this.entityData.set(DATA_AUDIO_RADIUS, (Object)Float.valueOf(input.getFloatOr("audio_radius", 64.0f)));
        this.loadSlideshow(input.read("slideshow", SlideshowHolder.CODEC).orElse(null), input.getDoubleOr("time", 0.0), input.getBooleanOr("paused", false));
        this.fallbackSlideshow = input.read("fallback_slideshow", SlideshowHolder.CODEC).orElse(null);
        this.requiresItemToView = input.getBooleanOr("requires_item_to_view", false);
        this.insideBoxToView = input.read("inside_box_to_view", AABB_CODEC).orElse(null);
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        return false;
    }

    public void move(MoverType type, Vec3 movement) {
    }

    public void push(double x, double y, double z) {
    }
}

