/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.slideshow;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Duration;
import java.util.Optional;
import org.lovetropics.multimedia.mod.slideshow.SlideContent;
import org.lovetropics.multimedia.mod.slideshow.SlideTransition;

public record Slide(SlideContent content, Optional<SlideTransition> transitionIn, Optional<SlideTransition> transitionOut) {
    public static final Codec<Duration> SECONDS_CODEC = Codec.FLOAT.xmap(seconds -> Duration.ofMillis((long)(seconds.floatValue() * 1000.0f)), duration -> Float.valueOf((float)duration.toMillis() / 1000.0f));
    public static final Codec<Slide> CODEC = RecordCodecBuilder.create(i -> i.group((App)SlideContent.MAP_CODEC.forGetter(Slide::content), (App)SlideTransition.CODEC.optionalFieldOf("transition_in").forGetter(Slide::transitionIn), (App)SlideTransition.CODEC.optionalFieldOf("transition_out").forGetter(Slide::transitionOut)).apply((Applicative)i, Slide::new));

    public Duration duration() {
        return this.content.duration();
    }
}

