/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.slideshow;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Duration;
import java.util.stream.Stream;
import net.minecraft.util.StringRepresentable;
import org.lovetropics.multimedia.mod.MediaFile;
import org.lovetropics.multimedia.mod.slideshow.Slide;
import org.lovetropics.multimedia.mod.slideshow.SlideDecorations;

public sealed interface SlideContent {
    public static final float MAX_VOLUME = 10.0f;
    public static final MapCodec<SlideContent> MAP_CODEC = Type.CODEC.dispatchMap(SlideContent::type, type -> type.codec);

    public Stream<MediaFile> files();

    public Duration duration();

    public Type type();

    public static enum Type implements StringRepresentable
    {
        VIDEO("video", Video.MAP_CODEC),
        IMAGE("image", Image.MAP_CODEC),
        BLANK("blank", Blank.MAP_CODEC);

        public static final Codec<Type> CODEC;
        private final String name;
        private final MapCodec<? extends SlideContent> codec;

        private Type(String name, MapCodec<? extends SlideContent> codec) {
            this.name = name;
            this.codec = codec;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    public record Blank(SlideDecorations decorations, Duration duration) implements SlideContent
    {
        public static final MapCodec<Blank> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SlideDecorations.MAP_CODEC.forGetter(Blank::decorations), (App)Slide.SECONDS_CODEC.fieldOf("duration").forGetter(Blank::duration)).apply((Applicative)i, Blank::new));

        @Override
        public Stream<MediaFile> files() {
            return Stream.empty();
        }

        @Override
        public Type type() {
            return Type.BLANK;
        }
    }

    public record Image(MediaFile file, SlideDecorations decorations, Duration duration) implements SlideContent
    {
        public static final MapCodec<Image> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)MediaFile.CODEC.fieldOf("file").forGetter(Image::file), (App)SlideDecorations.MAP_CODEC.forGetter(Image::decorations), (App)Slide.SECONDS_CODEC.fieldOf("duration").forGetter(Image::duration)).apply((Applicative)i, Image::new));

        @Override
        public Stream<MediaFile> files() {
            return Stream.of(this.file);
        }

        @Override
        public Type type() {
            return Type.IMAGE;
        }
    }

    public record Video(MediaFile file, Duration startAt, Duration duration, float volume) implements SlideContent
    {
        public static final MapCodec<Video> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)MediaFile.CODEC.fieldOf("file").forGetter(Video::file), (App)Slide.SECONDS_CODEC.optionalFieldOf("start_at", (Object)Duration.ZERO).forGetter(Video::startAt), (App)Slide.SECONDS_CODEC.fieldOf("duration").forGetter(Video::duration), (App)Codec.floatRange((float)0.0f, (float)10.0f).optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(Video::volume)).apply((Applicative)i, Video::new));

        @Override
        public Stream<MediaFile> files() {
            return Stream.of(this.file);
        }

        @Override
        public Type type() {
            return Type.VIDEO;
        }
    }
}

