/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.slideshow;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Duration;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.lovetropics.multimedia.mod.MediaFile;
import org.lovetropics.multimedia.mod.client.cache.MediaFileCache;
import org.lovetropics.multimedia.mod.slideshow.Slide;
import org.lovetropics.multimedia.mod.slideshow.SlideTransition;

public record Slideshow(List<Slide> slides, SlideTransition defaultTransition, boolean looping) {
    public static final Codec<Slideshow> CODEC = RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.nonEmptyList((Codec)Slide.CODEC.listOf()).fieldOf("slides").forGetter(Slideshow::slides), (App)SlideTransition.CODEC.optionalFieldOf("default_transition", (Object)SlideTransition.NONE).forGetter(Slideshow::defaultTransition), (App)Codec.BOOL.optionalFieldOf("looping", (Object)false).forGetter(Slideshow::looping)).apply((Applicative)i, Slideshow::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Slideshow> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);

    public Stream<MediaFile> files() {
        return this.slides.stream().flatMap(slide -> slide.content().files()).distinct();
    }

    public Duration duration() {
        Duration duration = Duration.ZERO;
        for (Slide slide : this.slides) {
            duration = duration.plus(slide.duration());
        }
        return duration;
    }

    public void ensureDownloaded(MediaFileCache mediaCache) {
        this.files().forEach(mediaCache::ensureDownloaded);
    }
}

