/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.slideshow;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.StrictJsonParser;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import org.jetbrains.annotations.Nullable;
import org.lovetropics.multimedia.mod.MediaFile;
import org.lovetropics.multimedia.mod.MultimediaMod;
import org.lovetropics.multimedia.mod.slideshow.Slide;
import org.lovetropics.multimedia.mod.slideshow.SlideContent;
import org.lovetropics.multimedia.mod.slideshow.SlideTransition;
import org.lovetropics.multimedia.mod.slideshow.Slideshow;
import org.lovetropics.multimedia.mod.slideshow.SlideshowHolder;
import org.slf4j.Logger;

@EventBusSubscriber(modid="multimedia")
public class SlideshowRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter LISTER = FileToIdConverter.json((String)"slideshow");
    public static final Map<ResourceLocation, SlideshowHolder> REGISTRY = new HashMap<ResourceLocation, SlideshowHolder>();
    private static final Map<ResourceLocation, SlideshowHolder> IMPORTED_REGISTRY = new HashMap<ResourceLocation, SlideshowHolder>();

    @SubscribeEvent
    public static void addReloadListener(AddServerReloadListenersEvent event) {
        RegistryAccess registries = event.getRegistryAccess();
        event.addListener(MultimediaMod.location("slideshows"), (barrier, resourceManager, backgroundExecutor, gameExecutor) -> ((CompletableFuture)SlideshowRegistry.load(registries, resourceManager, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0))).thenAcceptAsync(slideshows -> {
            REGISTRY.clear();
            slideshows.forEach(holder -> REGISTRY.put(holder.id(), (SlideshowHolder)holder));
            REGISTRY.putAll(IMPORTED_REGISTRY);
        }, gameExecutor));
    }

    public static ResourceLocation importSimpleVideo(ResourceLocation name, URI url, double duration) {
        ResourceLocation id = name.withPrefix("import/");
        Slideshow slideshow = new Slideshow(List.of(new Slide(new SlideContent.Video(new MediaFile(url), Duration.ZERO, Duration.ofSeconds((long)(duration * 1000.0)), 1.0f), Optional.empty(), Optional.empty())), SlideTransition.NONE, false);
        SlideshowHolder holder = new SlideshowHolder(id, slideshow);
        REGISTRY.put(id, holder);
        IMPORTED_REGISTRY.put(id, holder);
        return id;
    }

    private static CompletableFuture<List<SlideshowHolder>> load(RegistryAccess registryAccess, ResourceManager resourceManager, Executor executor) {
        RegistryOps ops = registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        return CompletableFuture.supplyAsync(() -> SlideshowRegistry.listEntries((DynamicOps<JsonElement>)ops, resourceManager, executor), executor).thenCompose(Function.identity());
    }

    private static CompletableFuture<List<SlideshowHolder>> listEntries(DynamicOps<JsonElement> ops, ResourceManager resourceManager, Executor executor) {
        List<CompletableFuture> futures = LISTER.listMatchingResources(resourceManager).entrySet().stream().map(resource -> {
            ResourceLocation path = (ResourceLocation)resource.getKey();
            ResourceLocation id = LISTER.fileToId(path);
            return CompletableFuture.supplyAsync(() -> {
                Slideshow slideshow = SlideshowRegistry.loadSlideshow(ops, path, (Resource)resource.getValue());
                return slideshow != null ? new SlideshowHolder(id, slideshow) : null;
            }, executor);
        }).toList();
        return Util.sequence(futures).thenApply(slideshows -> slideshows.stream().filter(Objects::nonNull).toList());
    }

    @Nullable
    private static Slideshow loadSlideshow(DynamicOps<JsonElement> ops, ResourceLocation path, Resource resource) {
        Slideshow slideshow;
        block8: {
            BufferedReader reader = resource.openAsReader();
            try {
                slideshow = (Slideshow)Slideshow.CODEC.parse(ops, (Object)StrictJsonParser.parse((Reader)reader)).getOrThrow(JsonSyntaxException::new);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    LOGGER.error("Failed to load media slideshow at {}", (Object)path, (Object)e);
                    return null;
                }
            }
            reader.close();
        }
        return slideshow;
    }
}

