/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.slideshow.instance;

import com.lovetropics.lib.slideshow.SlideshowInstanceHandle;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lovetropics.multimedia.mod.PlaybackClock;
import org.lovetropics.multimedia.mod.network.ClientboundClearSlideshowPacket;
import org.lovetropics.multimedia.mod.network.ClientboundSeekSlideshowPacket;
import org.lovetropics.multimedia.mod.network.ClientboundStartSlideshowPacket;
import org.lovetropics.multimedia.mod.network.SlideshowNetworkId;
import org.lovetropics.multimedia.mod.slideshow.SlideshowHolder;
import org.lovetropics.multimedia.mod.slideshow.instance.ServerSlideshowManager;

public class ServerFullScreenSlideshow
implements SlideshowInstanceHandle {
    private final ServerSlideshowManager slideshowManager;
    private final SlideshowHolder slideshow;
    private final double totalTime;
    private final PlaybackClock clock = new PlaybackClock();
    private final Set<ServerPlayer> players = new ReferenceOpenHashSet();

    ServerFullScreenSlideshow(ServerSlideshowManager slideshowManager, SlideshowHolder slideshow) {
        this.slideshowManager = slideshowManager;
        this.slideshow = slideshow;
        this.totalTime = (double)slideshow.value().duration().toMillis() / 1000.0;
    }

    public SlideshowHolder slideshow() {
        return this.slideshow;
    }

    boolean tick() {
        this.players.removeIf(Entity::isRemoved);
        return this.players.isEmpty() || this.currentTime() >= this.totalTime && !this.slideshow.value().looping();
    }

    public void addPlayer(ServerPlayer player) {
        this.slideshowManager.removePlayerFromOthers(player, this);
        if (this.players.add(player)) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundStartSlideshowPacket(SlideshowNetworkId.FULL_SCREEN, this.slideshow.value(), this.currentTime(), this.clock.isPaused()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.slideshowManager.ensureRegistered(this);
        }
    }

    public void removePlayer(ServerPlayer player) {
        if (this.players.remove(player) && !player.isRemoved()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundClearSlideshowPacket(SlideshowNetworkId.FULL_SCREEN), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    void replacePlayer(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        if (this.players.remove(oldPlayer)) {
            this.players.add(newPlayer);
        }
    }

    public boolean isPlayerWatching(ServerPlayer player) {
        return this.players.contains(player);
    }

    public void seekTo(double time, boolean paused) {
        this.clock.set(time, paused);
        this.broadcast(new ClientboundSeekSlideshowPacket(SlideshowNetworkId.FULL_SCREEN, time, paused));
    }

    public double currentTime() {
        return this.clock.getElapsedTime();
    }

    public double totalTime() {
        return this.totalTime;
    }

    public boolean isPaused() {
        return this.clock.isPaused();
    }

    public void close() {
        this.broadcast(new ClientboundClearSlideshowPacket(SlideshowNetworkId.FULL_SCREEN));
        this.players.clear();
        this.slideshowManager.remove(this);
    }

    private void broadcast(CustomPacketPayload packet) {
        for (ServerPlayer player : this.players) {
            if (player.isRemoved()) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

