/*
 * Decompiled with CFR 0.152.
 */
package org.lovetropics.multimedia.mod.slideshow.instance;

import com.lovetropics.lib.slideshow.SlideshowInstanceHandle;
import com.lovetropics.lib.slideshow.SlideshowManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.lovetropics.multimedia.mod.entity.ScreenEntity;
import org.lovetropics.multimedia.mod.network.ClientboundPreloadMediaPacket;
import org.lovetropics.multimedia.mod.slideshow.SlideshowHolder;
import org.lovetropics.multimedia.mod.slideshow.SlideshowRegistry;
import org.lovetropics.multimedia.mod.slideshow.instance.ServerFullScreenSlideshow;

public class ServerSlideshowManager
implements SlideshowManager {
    private final List<ServerFullScreenSlideshow> fullScreenInstances = new ArrayList<ServerFullScreenSlideshow>();

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        this.fullScreenInstances.removeIf(ServerFullScreenSlideshow::tick);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getOriginal();
        if (player instanceof ServerPlayer) {
            ServerPlayer oldPlayer = (ServerPlayer)player;
            player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer newPlayer = (ServerPlayer)player;
                this.replacePlayer(oldPlayer, newPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        for (ServerFullScreenSlideshow instance : this.fullScreenInstances) {
            instance.removePlayer(player2);
        }
    }

    @Nullable
    public ServerFullScreenSlideshow open(ResourceLocation id) {
        SlideshowHolder slideshow = SlideshowRegistry.REGISTRY.get(id);
        return slideshow != null ? this.open(slideshow) : null;
    }

    public ServerFullScreenSlideshow open(SlideshowHolder slideshow) {
        return new ServerFullScreenSlideshow(this, slideshow);
    }

    public void preload(ServerPlayer player, ResourceLocation id) {
        SlideshowHolder slideshow = SlideshowRegistry.REGISTRY.get(id);
        if (slideshow != null) {
            this.preload(player, slideshow);
        }
    }

    public void replacePlayer(ServerPlayer oldPlayer, ServerPlayer newPlayer) {
        for (ServerFullScreenSlideshow instance : this.fullScreenInstances) {
            instance.replacePlayer(oldPlayer, newPlayer);
        }
    }

    @Nullable
    public ResourceLocation importSimpleVideo(ResourceLocation name, URI url, double duration) {
        return SlideshowRegistry.importSimpleVideo(name, url, duration);
    }

    public void preload(ServerPlayer player, SlideshowHolder slideshow) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundPreloadMediaPacket(slideshow.value().files().toList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void clear(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerFullScreenSlideshow instance = this.byPlayer(player);
            if (instance != null) {
                instance.removePlayer(player);
            }
        } else if (entity instanceof ScreenEntity) {
            ScreenEntity screen = (ScreenEntity)entity;
            screen.setSlideshow(null);
        }
    }

    @Nullable
    public SlideshowInstanceHandle byEntity(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return this.byPlayer(player);
        }
        if (entity instanceof ScreenEntity) {
            ScreenEntity screen = (ScreenEntity)entity;
            return screen.asHandle();
        }
        return null;
    }

    @Nullable
    public ServerFullScreenSlideshow byPlayer(ServerPlayer player) {
        for (ServerFullScreenSlideshow instance : this.fullScreenInstances) {
            if (!instance.isPlayerWatching(player)) continue;
            return instance;
        }
        return null;
    }

    void ensureRegistered(ServerFullScreenSlideshow instance) {
        if (!this.fullScreenInstances.contains(instance)) {
            this.fullScreenInstances.add(instance);
        }
    }

    void remove(ServerFullScreenSlideshow instance) {
        this.fullScreenInstances.remove(instance);
    }

    void removePlayerFromOthers(ServerPlayer player, ServerFullScreenSlideshow instance) {
        for (ServerFullScreenSlideshow otherInstance : this.fullScreenInstances) {
            if (otherInstance == instance) continue;
            otherInstance.removePlayer(player);
        }
    }
}

