/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.supermartijn642.fusion.FusionClient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockModelModifierBakedModel
implements BlockStateModel {
    private final BlockStateModel original;
    private final List<BlockStateModel> models;
    private final boolean showBreakingOverlay;

    public BlockModelModifierBakedModel(BlockStateModel original, List<BlockStateModel> models, boolean showBreakingOverlay) {
        this.original = original;
        this.models = new ArrayList<BlockStateModel>(models.size() + 1);
        this.models.add(original);
        this.models.addAll(models);
        this.showBreakingOverlay = showBreakingOverlay;
    }

    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        if (!this.showBreakingOverlay && FusionClient.IS_RENDERING_BREAKING_OVERLAY.get() != null) {
            this.original.collectParts(level, pos, state, random, parts);
            return;
        }
        this.models.forEach(model -> model.collectParts(level, pos, state, random, parts));
    }

    @Nullable
    public Object createGeometryKey(BlockAndTintGetter blockView, BlockPos pos, BlockState state, RandomSource random) {
        ArrayList<Object> keys = new ArrayList<Object>(this.models.size() + 2);
        keys.add(this);
        keys.add(this.original.createGeometryKey(blockView, pos, state, random));
        for (BlockStateModel model : this.models) {
            keys.add(model.createGeometryKey(blockView, pos, state, random));
        }
        return keys;
    }

    public void collectParts(RandomSource random, List<BlockModelPart> parts) {
        if (!this.showBreakingOverlay && FusionClient.IS_RENDERING_BREAKING_OVERLAY.get() != null) {
            this.original.collectParts(random, parts);
            return;
        }
        this.models.forEach(model -> model.collectParts(random, parts));
    }

    public TextureAtlasSprite particleIcon() {
        return this.original.particleIcon();
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        return this.original.particleIcon(level, pos, state);
    }
}

