/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras;

import com.lovetropics.extras.EverythingTag;
import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.client.particle.ExtraParticles;
import com.lovetropics.extras.client.renderer.dummy.DummyPlayerEntityRenderer;
import com.lovetropics.extras.command.GenerateCommand;
import com.lovetropics.extras.command.SetMaxPlayersCommand;
import com.lovetropics.extras.entity.DummyPlayerEntity;
import com.lovetropics.extras.network.LTExtrasNetwork;
import com.lovetropics.extras.repack.registrate.Registrate;
import com.lovetropics.extras.repack.registrate.providers.ProviderType;
import com.lovetropics.extras.repack.registrate.util.NonNullLazyValue;
import com.lovetropics.extras.repack.registrate.util.entry.RegistryEntry;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="ltextras")
public class LTExtras {
    public static final String MODID = "ltextras";
    public static final ItemGroup ITEM_GROUP = new ItemGroup("ltextras"){

        public ItemStack func_78016_d() {
            return ExtraBlocks.BUOY.asStack();
        }

        public void func_78018_a(NonNullList<ItemStack> stacks) {
            super.func_78018_a(stacks);
            List order = LTExtras.registrate().getAll(Item.class).stream().map(RegistryEntry::get).collect(Collectors.toList());
            stacks.sort(Comparator.comparingInt(i -> order.indexOf(i.func_77973_b())));
        }
    };
    private static NonNullLazyValue<Registrate> registrate = new NonNullLazyValue<Registrate>(() -> (Registrate)Registrate.create(MODID).itemGroup(() -> ITEM_GROUP));
    private static final Pattern QUALIFIER = Pattern.compile("-\\w+\\+\\d+");

    public static Registrate registrate() {
        return registrate.get();
    }

    public LTExtras() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(LTExtras::getCompatVersion, (s, v) -> LTExtras.isCompatibleVersion(s)));
        ExtraBlocks.init();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ExtraParticles.REGISTER.register(modBus);
        DummyPlayerEntity.register();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modBus.addListener(this::clientSetup);
            modBus.addListener(this::registerItemColors);
        });
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        LTExtras.registrate().addDataGenerator(ProviderType.LANG, p -> p.add(ITEM_GROUP, "LTExtras"));
        ModList.get().getModContainerById("worldedit").ifPresent(worldedit -> {
            Supplier extension = (Supplier)ObfuscationReflectionHelper.getPrivateValue(ModContainer.class, (Object)worldedit, (String)"contextExtension");
            ModLoadingContext.get().setActiveContainer(worldedit, extension.get());
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        });
        LTExtrasNetwork.register();
    }

    public static String getCompatVersion() {
        return LTExtras.getCompatVersion(((ModContainer)ModList.get().getModContainerById(MODID).orElseThrow(IllegalStateException::new)).getModInfo().getVersion().toString());
    }

    private static String getCompatVersion(String fullVersion) {
        return QUALIFIER.matcher(fullVersion).replaceAll("");
    }

    public static boolean isCompatibleVersion(String version) {
        return LTExtras.getCompatVersion().equals(LTExtras.getCompatVersion(version));
    }

    private void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        NetworkTagManager tagManager = event.getServer().func_199731_aO();
        EverythingTag.addTo(tagManager.func_199717_a(), ForgeRegistries.BLOCKS);
        EverythingTag.addTo(tagManager.func_199715_b(), ForgeRegistries.ITEMS);
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        SetMaxPlayersCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        GenerateCommand.register((CommandDispatcher<CommandSource>)dispatcher);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(DummyPlayerEntity.DUMMY_PLAYER.get(), DummyPlayerEntityRenderer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item evt) {
        evt.getItemColors().func_199877_a((stack, index) -> index == 0 ? Fluids.field_204546_a.getAttributes().getColor() : -1, new IItemProvider[]{(IItemProvider)ExtraBlocks.WATER_BARRIER.get(), (IItemProvider)ExtraBlocks.FAKE_WATER.get()});
    }
}

