/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.lovetropics.extras.client.particle.ExtraParticles;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CheckpointBlock
extends Block {
    public static final IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)1, (int)40);

    public CheckpointBlock(Block.Properties properties) {
        super(properties);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{STAGE});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (worldIn instanceof World && ((World)worldIn).field_72995_K && context.getEntity() instanceof PlayerEntity && !((PlayerEntity)context.getEntity()).func_184812_l_()) {
            return VoxelShapes.func_197880_a();
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new StringTextComponent("Stage: ").func_150257_a(new StringTextComponent(Integer.toString(this.getStage(stack))).func_211708_a(TextFormatting.AQUA)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(this.getStage(context.func_195996_i())));
    }

    private int getStage(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("stage", 3)) {
            return tag.func_74762_e("stage");
        }
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (this.isHoldingBarrier((PlayerEntity)player)) {
            world.func_195594_a((IParticleData)ExtraParticles.CHECKPOINT.get(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private boolean isHoldingBarrier(PlayerEntity player) {
        Item item = this.func_199767_j();
        return player.func_184614_ca().func_77973_b() == item || player.func_184592_cb().func_77973_b() == item;
    }
}

