/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class GirderBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final Map<Direction.Axis, BooleanProperty> PROPS = (Map)Arrays.stream(Direction.Axis.values()).collect(Maps.toImmutableEnumMap(Function.identity(), a -> BooleanProperty.func_177716_a((String)a.func_176610_l())));
    public static final Map<Direction.Axis, VoxelShape> BASE_SHAPES = ImmutableMap.builder().put((Object)Direction.Axis.X, (Object)Block.func_208617_a((double)0.0, (double)3.0, (double)5.0, (double)16.0, (double)13.0, (double)11.0)).put((Object)Direction.Axis.Y, (Object)Block.func_208617_a((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0)).put((Object)Direction.Axis.Z, (Object)Block.func_208617_a((double)5.0, (double)3.0, (double)0.0, (double)11.0, (double)13.0, (double)16.0)).build();
    private final LazyValue<Map<BlockState, VoxelShape>> ALL_SHAPES = new LazyValue(() -> this.func_176194_O().func_177619_a().stream().collect(Collectors.toMap(Function.identity(), s -> {
        VoxelShape ret = VoxelShapes.func_197880_a();
        for (Direction.Axis a : Direction.Axis.values()) {
            if (!((Boolean)s.func_177229_b((IProperty)PROPS.get(a))).booleanValue()) continue;
            ret = VoxelShapes.func_197872_a((VoxelShape)ret, (VoxelShape)BASE_SHAPES.get(a));
        }
        return ret;
    })));
    private final Tag<Block> connectionTag;

    public GirderBlock(Tag<Block> connectionTag, Block.Properties properties) {
        super(properties);
        this.connectionTag = connectionTag;
        this.func_180632_j((BlockState)PROPS.keySet().stream().reduce(this.func_176194_O().func_177621_b(), (s, a) -> (BlockState)s.func_206870_a((IProperty)PROPS.get(a), (Comparable)Boolean.valueOf(false)), (s1, s2) -> s1).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a((IProperty[])PROPS.values().toArray(new BooleanProperty[0])).func_206894_a(new IProperty[]{WATERLOGGED});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)((Map)this.ALL_SHAPES.func_179281_c()).get(state);
    }

    @Deprecated
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean connected = false;
        for (Direction dir : Direction.values()) {
            if (!context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(dir)).func_203425_a(this.connectionTag)) continue;
            state = (BlockState)state.func_206870_a((IProperty)PROPS.get(dir.func_176740_k()), (Comparable)Boolean.valueOf(true));
            connected = true;
        }
        if (!connected) {
            state = (BlockState)state.func_206870_a((IProperty)PROPS.get(context.func_196000_l().func_176740_k()), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        BlockState ret = stateIn;
        boolean connected = false;
        for (Direction.Axis a : Direction.Axis.values()) {
            if (worldIn.func_180495_p(currentPos.func_177972_a(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)a))).func_203425_a(this.connectionTag) || worldIn.func_180495_p(currentPos.func_177972_a(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)a))).func_203425_a(this.connectionTag)) {
                connected = true;
                ret = (BlockState)ret.func_206870_a((IProperty)PROPS.get(a), (Comparable)Boolean.valueOf(true));
                continue;
            }
            ret = (BlockState)ret.func_206870_a((IProperty)PROPS.get(a), (Comparable)Boolean.valueOf(false));
        }
        if (!connected) {
            return stateIn;
        }
        return ret;
    }
}

