/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.command;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class GenerateCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DynamicCommandExceptionType FAILED_TO_WRITE = new DynamicCommandExceptionType(o -> new StringTextComponent("Failed to write to file: " + o));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"generate").requires(source -> source.func_197034_c(4))).then(Commands.func_197057_a((String)"tag").then(Commands.func_197057_a((String)"item").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"pattern", (ArgumentType)StringArgumentType.greedyString()).executes(GenerateCommand::generateItemTag))))));
    }

    private static int generateItemTag(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Pattern pattern = Pattern.compile(StringArgumentType.getString(ctx, (String)"pattern"));
        Tag.Builder tagBuilder = new Tag.Builder();
        for (Map.Entry e : ForgeRegistries.ITEMS.getEntries()) {
            if (!pattern.matcher(((ResourceLocation)e.getKey()).toString()).matches()) continue;
            tagBuilder.func_200048_a(e.getValue());
        }
        TagCollection tagcollection = new TagCollection($ -> Optional.empty(), "", false, "generated");
        tagcollection.func_219779_a((Map)Maps.newHashMap((Map)ImmutableMap.of((Object)new ResourceLocation("generated"), (Object)tagBuilder)));
        JsonObject json = ((Tag)tagcollection.func_200039_c().values().iterator().next()).func_200571_a(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0));
        Path output = Paths.get("export", "generated", "tags", "item", StringArgumentType.getString(ctx, (String)"name") + ".json");
        try {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.write(output, Collections.singleton(GSON.toJson((JsonElement)json)), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw FAILED_TO_WRITE.create((Object)e1);
        }
        return 1;
    }
}

