/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data;

import com.lovetropics.extras.block.GirderBlock;
import com.lovetropics.extras.data.TextureType;
import com.lovetropics.extras.repack.registrate.providers.DataGenContext;
import com.lovetropics.extras.repack.registrate.providers.RegistrateBlockstateProvider;
import com.lovetropics.extras.repack.registrate.util.nullness.NonNullBiConsumer;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.ScaffoldingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.registries.IRegistryDelegate;

public class ModelGenUtil {
    public static void steelGirderBlockstate(DataGenContext<Block, GirderBlock> ctx, RegistrateBlockstateProvider prov) {
        ResourceLocation template = prov.modLoc("block/girder_straight");
        ModelBuilder model = prov.models().singleTexture(ctx.getName(), template, prov.modLoc("block/" + ctx.getName()));
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder(ctx.get());
        ((MultiPartBlockStateBuilder.PartBuilder)ModelGenUtil.addSteelGirderVariants((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)builder.part(), (ModelFile)model, 90, 90).addModel()).condition((IProperty)GirderBlock.PROPS.get(Direction.Axis.X), (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)ModelGenUtil.addSteelGirderVariants((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)builder.part(), (ModelFile)model, 0, 0).addModel()).condition((IProperty)GirderBlock.PROPS.get(Direction.Axis.Y), (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)ModelGenUtil.addSteelGirderVariants((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)builder.part(), (ModelFile)model, 90, 0).addModel()).condition((IProperty)GirderBlock.PROPS.get(Direction.Axis.Z), (Comparable[])new Boolean[]{true}).end();
        ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> allModels = ModelGenUtil.addSteelGirderVariants((ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder>)builder.part(), (ModelFile)model, 90, 90);
        allModels = ModelGenUtil.addSteelGirderVariants(allModels, (ModelFile)model, 0, 0);
        allModels = ModelGenUtil.addSteelGirderVariants(allModels, (ModelFile)model, 90, 0);
        MultiPartBlockStateBuilder.PartBuilder allParts = (MultiPartBlockStateBuilder.PartBuilder)allModels.addModel();
        for (Direction.Axis a : Direction.Axis.values()) {
            allParts = allParts.condition((IProperty)GirderBlock.PROPS.get(a), (Comparable[])new Boolean[]{false});
        }
        allParts.end();
    }

    private static ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> addSteelGirderVariants(ConfiguredModel.Builder<MultiPartBlockStateBuilder.PartBuilder> builder, ModelFile model, int xRot, int yRot) {
        return builder.modelFile(model).rotationX(xRot).rotationY(yRot).weight(1).uvLock(true);
    }

    public static ConfiguredModel scaffoldingModel(DataGenContext<Block, ScaffoldingBlock> ctx, RegistrateBlockstateProvider prov, String suffix) {
        return new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + suffix, "scaffolding_" + suffix)).texture("bottom", prov.modLoc("block/metal_scaffolding_bottom"))).texture("top", prov.modLoc("block/metal_scaffolding_top"))).texture("side", prov.modLoc("block/metal_scaffolding_side"))).texture("particle", prov.modLoc("block/metal_scaffolding_top")));
    }

    public static void barsBlock(DataGenContext<Block, PaneBlock> ctx, RegistrateBlockstateProvider prov) {
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.getEntry());
        ModelFile cap = ModelGenUtil.barsModel(prov, ctx, "cap");
        ModelFile capAlt = ModelGenUtil.barsModel(prov, ctx, "cap_alt");
        ModelFile side = ModelGenUtil.barsModel(prov, ctx, "side");
        ModelFile sideAlt = ModelGenUtil.barsModel(prov, ctx, "side_alt");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(ModelGenUtil.barsModel(prov, ctx, "post_ends")).addModel()).end().part().modelFile(ModelGenUtil.barsModel(prov, ctx, "post")).addModel()).condition((IProperty)PaneBlock.field_196409_a, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196411_b, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196413_c, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196414_y, (Comparable[])new Boolean[]{false}).end().part().modelFile(cap).addModel()).condition((IProperty)PaneBlock.field_196409_a, (Comparable[])new Boolean[]{true}).condition((IProperty)PaneBlock.field_196411_b, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196413_c, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196414_y, (Comparable[])new Boolean[]{false}).end().part().modelFile(cap).rotationY(90).addModel()).condition((IProperty)PaneBlock.field_196409_a, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196411_b, (Comparable[])new Boolean[]{true}).condition((IProperty)PaneBlock.field_196413_c, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196414_y, (Comparable[])new Boolean[]{false}).end().part().modelFile(capAlt).addModel()).condition((IProperty)PaneBlock.field_196409_a, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196411_b, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196413_c, (Comparable[])new Boolean[]{true}).condition((IProperty)PaneBlock.field_196414_y, (Comparable[])new Boolean[]{false}).end().part().modelFile(capAlt).rotationY(90).addModel()).condition((IProperty)PaneBlock.field_196409_a, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196411_b, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196413_c, (Comparable[])new Boolean[]{false}).condition((IProperty)PaneBlock.field_196414_y, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).addModel()).condition((IProperty)PaneBlock.field_196409_a, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationY(90).addModel()).condition((IProperty)PaneBlock.field_196411_b, (Comparable[])new Boolean[]{true}).end().part().modelFile(sideAlt).addModel()).condition((IProperty)PaneBlock.field_196413_c, (Comparable[])new Boolean[]{true}).end().part().modelFile(sideAlt).rotationY(90).addModel()).condition((IProperty)PaneBlock.field_196414_y, (Comparable[])new Boolean[]{true}).end();
    }

    private static ModelFile barsModel(RegistrateBlockstateProvider prov, DataGenContext<Block, ?> ctx, String suffix) {
        ResourceLocation tex = prov.blockTexture((Block)ctx.getEntry());
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + suffix, "block/iron_bars_" + suffix)).texture("bars", tex)).texture("edge", tex)).texture("particle", tex);
    }

    private static ResourceLocation blockTexture(ModelProvider<?> prov, Block block) {
        ResourceLocation base = block.getRegistryName();
        return new ResourceLocation(base.func_110624_b(), "block/" + base.func_110623_a());
    }

    private static ResourceLocation blockTexture(ModelProvider<?> prov, Block block, String suffix) {
        ResourceLocation base = ModelGenUtil.blockTexture(prov, block);
        return new ResourceLocation(base.func_110624_b(), base.func_110623_a() + "_" + suffix);
    }

    public static ResourceLocation getMainTexture(ModelProvider<?> prov, Block block, TextureType texture) {
        switch (texture) {
            case NORMAL: {
                return ModelGenUtil.blockTexture(prov, block);
            }
            case SIDE_TOP: {
                return ModelGenUtil.blockTexture(prov, block, "side");
            }
        }
        throw new IllegalArgumentException();
    }

    public static <T extends StairsBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> stairsBlock(Map.Entry<IRegistryDelegate<Block>, TextureType> entry) {
        switch (entry.getValue()) {
            case NORMAL: {
                return (ctx, prov) -> prov.stairsBlock((StairsBlock)ctx.getEntry(), prov.blockTexture((Block)((IRegistryDelegate)entry.getKey()).get()));
            }
            case SIDE_TOP: {
                return (ctx, prov) -> prov.stairsBlock((StairsBlock)ctx.getEntry(), ModelGenUtil.blockTexture(prov.models(), (Block)((IRegistryDelegate)entry.getKey()).get(), "side"), ModelGenUtil.blockTexture(prov.models(), (Block)((IRegistryDelegate)entry.getKey()).get(), "top"), ModelGenUtil.blockTexture(prov.models(), (Block)((IRegistryDelegate)entry.getKey()).get(), "top"));
            }
        }
        throw new IllegalArgumentException();
    }

    public static <T extends SlabBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> slabBlock(Map.Entry<IRegistryDelegate<Block>, TextureType> entry) {
        switch (entry.getValue()) {
            case NORMAL: {
                return (ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), prov.blockTexture((Block)((IRegistryDelegate)entry.getKey()).get()), prov.blockTexture((Block)((IRegistryDelegate)entry.getKey()).get()));
            }
            case SIDE_TOP: {
                return (ctx, prov) -> prov.slabBlock((SlabBlock)ctx.getEntry(), ModelGenUtil.blockTexture(prov.models(), (Block)((IRegistryDelegate)entry.getKey()).get(), "side"), ModelGenUtil.blockTexture(prov.models(), (Block)((IRegistryDelegate)entry.getKey()).get(), "side"), ModelGenUtil.blockTexture(prov.models(), (Block)((IRegistryDelegate)entry.getKey()).get(), "top"), ModelGenUtil.blockTexture(prov.models(), (Block)((IRegistryDelegate)entry.getKey()).get(), "top"));
            }
        }
        throw new IllegalArgumentException();
    }

    public static <T extends FenceBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> fenceBlock(Map.Entry<IRegistryDelegate<Block>, TextureType> entry) {
        switch (entry.getValue()) {
            case NORMAL: {
                return (ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.getEntry(), prov.blockTexture((Block)((IRegistryDelegate)entry.getKey()).get()));
            }
            case SIDE_TOP: {
                return (ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.getEntry(), ModelGenUtil.getMainTexture(prov.models(), (Block)((IRegistryDelegate)entry.getKey()).get(), (TextureType)((Object)((Object)entry.getValue()))));
            }
        }
        throw new IllegalArgumentException();
    }

    public static <T extends WallBlock> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> wallBlock(Map.Entry<IRegistryDelegate<Block>, TextureType> entry) {
        switch (entry.getValue()) {
            case NORMAL: {
                return (ctx, prov) -> prov.wallBlock((WallBlock)ctx.getEntry(), prov.blockTexture((Block)((IRegistryDelegate)entry.getKey()).get()));
            }
            case SIDE_TOP: {
                return (ctx, prov) -> prov.wallBlock((WallBlock)ctx.getEntry(), ModelGenUtil.getMainTexture(prov.models(), (Block)((IRegistryDelegate)entry.getKey()).get(), (TextureType)((Object)((Object)entry.getValue()))));
            }
        }
        throw new IllegalArgumentException();
    }
}

