/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.entity.UpdateDummyTexturesMessage;
import com.lovetropics.extras.item.DummyPlayerItem;
import com.lovetropics.extras.network.LTExtrasNetwork;
import com.lovetropics.extras.repack.registrate.Registrate;
import com.lovetropics.extras.repack.registrate.util.entry.ItemEntry;
import com.lovetropics.extras.repack.registrate.util.entry.RegistryEntry;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;

public class DummyPlayerEntity
extends ArmorStandEntity {
    public static final RegistryEntry<EntityType<DummyPlayerEntity>> DUMMY_PLAYER = ((Registrate)LTExtras.registrate().object("dummy_player")).entity(DummyPlayerEntity::new, EntityClassification.MISC).properties(b -> b.func_220321_a(0.6f, 1.8f)).register();
    public static final ItemEntry<DummyPlayerItem> SPAWNER = LTExtras.registrate().item(DummyPlayerItem::new).register();
    private static final IDataSerializer<GameProfile> PROFILE_SERIALIZER = new IDataSerializer<GameProfile>(){

        public GameProfile copyValue(GameProfile value) {
            return value == null ? null : new GameProfile(value.getId(), value.getName());
        }

        public GameProfile read(PacketBuffer buf) {
            byte mode = buf.readByte();
            UUID id = null;
            String name = null;
            if ((mode & 1) > 0) {
                id = buf.func_179253_g();
            }
            if ((mode & 2) > 0) {
                name = buf.func_150789_c(100);
            }
            if (id == null && name == null) {
                return null;
            }
            return new GameProfile(id, name);
        }

        public void write(PacketBuffer buf, GameProfile value) {
            int mode = 0;
            if (value != null && value.getId() != null) {
                mode |= 1;
            }
            if (value != null && value.getName() != null) {
                mode |= 2;
            }
            buf.writeByte(mode);
            if ((mode & 1) > 0) {
                buf.func_179252_a(value.getId());
            }
            if ((mode & 2) > 0) {
                buf.func_211400_a(value.getName(), 100);
            }
        }
    };
    private static final DataParameter<GameProfile> GAME_PROFILE;
    private static final DataParameter<Optional<ITextComponent>> PREFIX;
    private static final DataParameter<Optional<ITextComponent>> SUFFIX;
    private static final LazyValue<PlayerProfileCache> PROFILE_CACHE;
    private boolean reloadTextures = true;
    private final Map<MinecraftProfileTexture.Type, ResourceLocation> playerTextures = Maps.newEnumMap(MinecraftProfileTexture.Type.class);
    @Nullable
    private String skinType;

    public static void register() {
    }

    protected DummyPlayerEntity(EntityType<? extends DummyPlayerEntity> type, World worldIn) {
        super(type, worldIn);
        if (!worldIn.field_72995_K) {
            this.field_70180_af.func_187227_b(field_184801_a, (Object)4);
        }
    }

    public DummyPlayerEntity(World worldIn, double posX, double posY, double posZ) {
        this(DUMMY_PLAYER.get(), worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GAME_PROFILE, null);
        this.field_70180_af.func_187214_a(PREFIX, Optional.empty());
        this.field_70180_af.func_187214_a(SUFFIX, Optional.empty());
    }

    public ITextComponent func_225513_by_() {
        return this.getProfile() == null || this.getProfile().getName() == null ? super.func_225513_by_() : new StringTextComponent(this.getProfile().getName());
    }

    public ITextComponent func_145748_c_() {
        ITextComponent ret = super.func_145748_c_().func_212638_h();
        ITextComponent prefix = ((Optional)this.field_70180_af.func_187225_a(PREFIX)).orElse(null);
        ITextComponent suffix = ((Optional)this.field_70180_af.func_187225_a(SUFFIX)).orElse(null);
        if (prefix != null) {
            ret = prefix.func_212638_h().func_150257_a(ret);
        }
        if (suffix != null) {
            ret = ret.func_150257_a(suffix.func_212638_h());
        }
        return ret;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)SPAWNER.get());
    }

    public GameProfile getProfile() {
        return (GameProfile)this.field_70180_af.func_187225_a(GAME_PROFILE);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ((Optional)this.field_70180_af.func_187225_a(PREFIX)).ifPresent(prefix -> compound.func_74778_a("NamePrefix", ITextComponent.Serializer.func_150696_a((ITextComponent)prefix)));
        ((Optional)this.field_70180_af.func_187225_a(SUFFIX)).ifPresent(suffix -> compound.func_74778_a("NameSuffix", ITextComponent.Serializer.func_150696_a((ITextComponent)suffix)));
        GameProfile profile = this.getProfile();
        if (profile == null) {
            return;
        }
        if (profile.getId() != null) {
            compound.func_186854_a("ProfileID", profile.getId());
        } else if (profile.getName() != null) {
            compound.func_74778_a("ProfileName", profile.getName());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("NamePrefix", 8)) {
            this.field_70180_af.func_187227_b(PREFIX, Optional.ofNullable(ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("NamePrefix"))));
        }
        if (compound.func_150297_b("NameSuffix", 8)) {
            this.field_70180_af.func_187227_b(SUFFIX, Optional.ofNullable(ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("NameSuffix"))));
        }
        if (compound.func_150297_b("ProfileName", 8)) {
            String name = compound.func_74779_i("ProfileName");
            if (!StringUtils.isBlank((CharSequence)name)) {
                this.field_70180_af.func_187227_b(GAME_PROFILE, (Object)new GameProfile(null, compound.func_74779_i("ProfileName")));
            } else {
                this.field_70180_af.func_187227_b(GAME_PROFILE, null);
            }
            this.fillProfile();
        } else if (compound.func_186855_b("ProfileID")) {
            String existingName = this.getProfile() == null ? null : this.getProfile().getName();
            UUID newId = compound.func_186857_a("ProfileID");
            if (this.getProfile() == null || this.getProfile().getId() == null && this.getProfile().getName() == null || !this.getProfile().getId().equals(newId)) {
                this.field_70180_af.func_187227_b(GAME_PROFILE, (Object)new GameProfile(compound.func_186857_a("ProfileID"), existingName));
                this.fillProfile();
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.reloadTextures) {
            LTExtrasNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateDummyTexturesMessage(this.func_145782_y()));
            this.reloadTextures = false;
        }
    }

    void fillProfile() {
        GameProfile profile = this.getProfile();
        if (profile == null) {
            this.reloadTextures();
        }
        CompletableFuture.supplyAsync(() -> {
            GameProfile ret;
            PlayerProfileCache cache;
            if (profile.getId() != null) {
                GameProfile ret2 = ((PlayerProfileCache)PROFILE_CACHE.func_179281_c()).func_152652_a(this.getProfile().getId());
                if (ret2 != null) {
                    return ret2;
                }
                try {
                    HttpURLConnection con = (HttpURLConnection)new URL("https://playerdb.co/api/player/minecraft/" + this.getProfile().getId().toString()).openConnection();
                    con.setRequestProperty("User-Agent", "LTDonations 1.0 (lovetropics.com)");
                    con.setRequestProperty("Content-Type", "application/json");
                    JsonObject response = (JsonObject)new Gson().fromJson(new JsonReader((Reader)new InputStreamReader(con.getInputStream())), JsonObject.class);
                    String username = response.getAsJsonObject("data").getAsJsonObject("player").get("username").getAsString();
                    return new GameProfile(this.getProfile().getId(), username);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return profile;
                }
            }
            PlayerProfileCache playerProfileCache = cache = (PlayerProfileCache)PROFILE_CACHE.func_179281_c();
            synchronized (playerProfileCache) {
                ret = cache.func_152655_a(this.getProfile().getName());
            }
            return ret == null ? profile : ret;
        }).thenAcceptAsync(gp -> {
            this.field_70180_af.func_187227_b(GAME_PROFILE, gp);
            this.reloadTextures();
        }, (Executor)this.func_184102_h());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    protected void updateSkinTexture() {
        if (this.reloadTextures) {
            DummyPlayerEntity dummyPlayerEntity = this;
            synchronized (dummyPlayerEntity) {
                if (this.reloadTextures) {
                    this.playerTextures.clear();
                    this.reloadTextures = false;
                    if (this.getProfile() == null || this.getProfile().getId() == null) {
                        return;
                    }
                    LogManager.getLogger().info("Loading skin data for GameProfile: " + this.getProfile());
                    Minecraft.func_71410_x().func_152342_ad().func_152790_a(this.getProfile(), (p_210250_1_, p_210250_2_, p_210250_3_) -> {
                        Map<MinecraftProfileTexture.Type, ResourceLocation> map = this.playerTextures;
                        synchronized (map) {
                            this.playerTextures.put(p_210250_1_, p_210250_2_);
                            if (p_210250_1_ == MinecraftProfileTexture.Type.SKIN) {
                                this.skinType = p_210250_3_.getMetadata("model");
                                if (this.skinType == null) {
                                    this.skinType = "default";
                                }
                            }
                        }
                    }, true);
                }
            }
        }
    }

    private UUID getSkinUUID() {
        return this.getProfile() == null || this.getProfile().getId() == null ? this.func_110124_au() : this.getProfile().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceLocation getSkin() {
        this.updateSkinTexture();
        Map<MinecraftProfileTexture.Type, ResourceLocation> map = this.playerTextures;
        synchronized (map) {
            return this.playerTextures.computeIfAbsent(MinecraftProfileTexture.Type.SKIN, $ -> DefaultPlayerSkin.func_177334_a((UUID)this.getSkinUUID()));
        }
    }

    public ResourceLocation getCape() {
        return this.playerTextures.get(MinecraftProfileTexture.Type.CAPE);
    }

    public ResourceLocation getElytra() {
        return this.playerTextures.getOrDefault(MinecraftProfileTexture.Type.ELYTRA, this.getCape());
    }

    public String getSkinType() {
        return this.skinType == null ? DefaultPlayerSkin.func_177332_b((UUID)this.getSkinUUID()) : this.skinType;
    }

    void reloadTextures() {
        this.reloadTextures = true;
    }

    static {
        DataSerializers.func_187189_a(PROFILE_SERIALIZER);
        GAME_PROFILE = EntityDataManager.func_187226_a(DummyPlayerEntity.class, PROFILE_SERIALIZER);
        PREFIX = EntityDataManager.func_187226_a(DummyPlayerEntity.class, (IDataSerializer)DataSerializers.field_200544_f);
        SUFFIX = EntityDataManager.func_187226_a(DummyPlayerEntity.class, (IDataSerializer)DataSerializers.field_200544_f);
        PROFILE_CACHE = new LazyValue(() -> new PlayerProfileCache(ServerLifecycleHooks.getCurrentServer().func_152359_aw(), new File(".", "dummyplayercache.json")));
    }
}

