/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.repack.ltlib.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class FireworkUtil {
    static final int CE_YELLOW = 16041012;
    static final int CE_BLUE = 6666715;
    static final int CE_GREEN = 11653785;
    static final int CE_RED = 15356243;
    static final int CE_ORANGE = 15763271;
    static final int CE_PURPLE = 8478886;
    static final int CE_NAVY = 3752019;
    private static final Random rand = new Random();

    @Nonnull
    public static FireworkRocketEntity getRandomFirework(@Nonnull World world) {
        return FireworkUtil.getRandomFirework(world, new BlockPos(0, 0, 0), new int[0][]);
    }

    @Nonnull
    public static FireworkRocketEntity getRandomFirework(@Nonnull World world, @Nonnull BlockPos pos, int[] ... palettes) {
        int[] colors;
        ItemStack firework = new ItemStack((IItemProvider)Items.field_196152_dE);
        firework.func_77982_d(new CompoundNBT());
        CompoundNBT expl = new CompoundNBT();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        if (palettes.length == 0) {
            colors = new int[rand.nextInt(8) + 1];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = DyeColor.values()[rand.nextInt(16)].getColorValue();
            }
        } else {
            int[] palette = palettes[rand.nextInt(palettes.length)];
            colors = new int[palette.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = palette[rand.nextInt(palette.length)];
            }
        }
        expl.func_74783_a("Colors", colors);
        byte type = (byte)(rand.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        expl.func_74774_a("Type", type);
        ListNBT explosions = new ListNBT();
        explosions.add((Object)expl);
        CompoundNBT fireworkTag = new CompoundNBT();
        fireworkTag.func_218657_a("Explosions", (INBT)explosions);
        fireworkTag.func_74774_a("Flight", (byte)1);
        firework.func_77983_a("Fireworks", (INBT)fireworkTag);
        FireworkRocketEntity e = new FireworkRocketEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, firework);
        return e;
    }

    public static void spawnFirework(@Nonnull BlockPos block, World world, int[] ... palettes) {
        FireworkUtil.spawnFirework(block, world, 0, palettes);
    }

    public static void spawnFirework(@Nonnull BlockPos pos, World world, int range, int[] ... palettes) {
        BlockPos spawnPos = pos;
        if (range > 0) {
            spawnPos = new BlockPos(FireworkUtil.moveRandomly(spawnPos.func_177958_n(), range), (double)spawnPos.func_177956_o(), FireworkUtil.moveRandomly(spawnPos.func_177952_p(), range));
            BlockState bs = world.func_180495_p(spawnPos);
            int tries = -1;
            while (!world.func_175623_d(new BlockPos((Vec3i)spawnPos)) && !bs.func_185904_a().func_76230_c()) {
                if (++tries <= 100) continue;
                return;
            }
        }
        world.func_217376_c((Entity)FireworkUtil.getRandomFirework(world, spawnPos, palettes));
    }

    private static double moveRandomly(double base, double range) {
        return base + 0.5 + rand.nextDouble() * range - range / 2.0;
    }

    public static enum Palette {
        FULL_RANDOM(new int[0][]),
        PUERTO_RICO(new int[][]{{11743532, 0xF0F0F0, 2437522, 6998340, 16105792, 1021572}}),
        COOL_EARTH({16041012, 6666715, 11653785}, {15356243, 15763271, 8478886}, {16041012, 6666715, 8478886}, {6666715, 11653785, 3752019}),
        ISLAND_ROYALE(new int[][]{{0}});

        private final int[][] palette;

        private Palette(int[] ... palette) {
            this.palette = palette;
        }

        public int[][] getPalette() {
            return this.palette;
        }
    }
}

