/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.repack.registrate.builders;

import com.lovetropics.extras.repack.registrate.AbstractRegistrate;
import com.lovetropics.extras.repack.registrate.builders.AbstractBuilder;
import com.lovetropics.extras.repack.registrate.builders.BuilderCallback;
import com.lovetropics.extras.repack.registrate.util.entry.RegistryEntry;
import com.lovetropics.extras.repack.registrate.util.nullness.NonNullConsumer;
import com.lovetropics.extras.repack.registrate.util.nullness.NonNullFunction;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.world.RegisterDimensionsEvent;

public class DimensionBuilder<T extends ModDimension, P>
extends AbstractBuilder<ModDimension, T, P, DimensionBuilder<T, P>> {
    private static final Map<DimensionInfo, NonNullConsumer<? super DimensionType>> ALL_DIMENSIONS = new ConcurrentHashMap<DimensionInfo, NonNullConsumer<? super DimensionType>>();
    private static final AtomicBoolean REGISTERED_EVENT_LISTENER = new AtomicBoolean();
    private final BiFunction<World, DimensionType, ? extends Dimension> dimFactory;
    private final NonNullFunction<BiFunction<World, DimensionType, ? extends Dimension>, T> factory;
    private NonNullConsumer<DimensionType> dimTypeCallback = NonNullConsumer.noop();
    @Nullable
    private NonNullConsumer<PacketBuffer> customData;
    private boolean hasSkyLight;
    private boolean keepLoaded;

    public static <P> DimensionBuilder<ModDimension, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BiFunction<World, DimensionType, ? extends Dimension> dimFactory) {
        return DimensionBuilder.create(owner, parent, name, callback, dimFactory, ModDimension::withFactory);
    }

    public static <T extends ModDimension, P> DimensionBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BiFunction<World, DimensionType, ? extends Dimension> dimFactory, NonNullFunction<BiFunction<World, DimensionType, ? extends Dimension>, T> factory) {
        return new DimensionBuilder<T, P>(owner, parent, name, callback, dimFactory, factory);
    }

    protected DimensionBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, BiFunction<World, DimensionType, ? extends Dimension> dimFactory, NonNullFunction<BiFunction<World, DimensionType, ? extends Dimension>, T> factory) {
        super(owner, parent, name, callback, ModDimension.class);
        this.factory = factory;
        this.dimFactory = dimFactory;
    }

    public DimensionBuilder<T, P> dimensionTypeCallback(NonNullConsumer<DimensionType> callback) {
        this.dimTypeCallback = callback;
        return this;
    }

    public DimensionBuilder<T, P> customData(NonNullConsumer<PacketBuffer> cons) {
        NonNullConsumer<PacketBuffer> customData = this.customData;
        this.customData = customData == null ? cons : customData.andThen(cons);
        return this;
    }

    public DimensionBuilder<T, P> hasSkyLight(boolean val) {
        this.hasSkyLight = val;
        return this;
    }

    public DimensionBuilder<T, P> keepLoaded(boolean val) {
        this.keepLoaded = val;
        return this;
    }

    @Override
    protected T createEntry() {
        return (T)((ModDimension)this.factory.apply(this.dimFactory));
    }

    @Override
    public RegistryEntry<T> register() {
        if (REGISTERED_EVENT_LISTENER.compareAndSet(false, true)) {
            MinecraftForge.EVENT_BUS.addListener(DimensionBuilder::registerDimensionTypes);
        }
        this.onRegister(d -> ALL_DIMENSIONS.put(new DimensionInfo((ModDimension)d, this.customData, this.hasSkyLight, this.keepLoaded), this.dimTypeCallback));
        return super.register();
    }

    protected static void registerDimensionTypes(RegisterDimensionsEvent event) {
        ALL_DIMENSIONS.forEach((d, c) -> {
            NonNullConsumer<PacketBuffer> extraData = d.getCustomData();
            PacketBuffer buf = null;
            if (extraData != null) {
                buf = new PacketBuffer(Unpooled.buffer());
                extraData.accept(buf);
            }
            DimensionType type = DimensionManager.registerOrGetDimension((ResourceLocation)d.getDim().getRegistryName(), (ModDimension)d.getDim(), (PacketBuffer)buf, (boolean)d.hasSkyLight());
            DimensionManager.keepLoaded((DimensionType)type, (boolean)d.keepLoaded());
            c.accept(type);
        });
    }

    private static final class DimensionInfo {
        private final ModDimension dim;
        @Nullable
        private final NonNullConsumer<PacketBuffer> customData;
        private final boolean hasSkyLight;
        private final boolean keepLoaded;

        public DimensionInfo(ModDimension dim, @Nullable NonNullConsumer<PacketBuffer> customData, boolean hasSkyLight, boolean keepLoaded) {
            this.dim = dim;
            this.customData = customData;
            this.hasSkyLight = hasSkyLight;
            this.keepLoaded = keepLoaded;
        }

        public ModDimension getDim() {
            return this.dim;
        }

        @Nullable
        public NonNullConsumer<PacketBuffer> getCustomData() {
            return this.customData;
        }

        public boolean hasSkyLight() {
            return this.hasSkyLight;
        }

        public boolean keepLoaded() {
            return this.keepLoaded;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DimensionInfo)) {
                return false;
            }
            DimensionInfo other = (DimensionInfo)o;
            ModDimension this$dim = this.getDim();
            ModDimension other$dim = other.getDim();
            if (this$dim == null ? other$dim != null : !this$dim.equals(other$dim)) {
                return false;
            }
            NonNullConsumer<PacketBuffer> this$customData = this.getCustomData();
            NonNullConsumer<PacketBuffer> other$customData = other.getCustomData();
            if (this$customData == null ? other$customData != null : !this$customData.equals(other$customData)) {
                return false;
            }
            if (this.hasSkyLight() != other.hasSkyLight()) {
                return false;
            }
            return this.keepLoaded() == other.keepLoaded();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ModDimension $dim = this.getDim();
            result = result * 59 + ($dim == null ? 43 : $dim.hashCode());
            NonNullConsumer<PacketBuffer> $customData = this.getCustomData();
            result = result * 59 + ($customData == null ? 43 : $customData.hashCode());
            result = result * 59 + (this.hasSkyLight() ? 79 : 97);
            result = result * 59 + (this.keepLoaded() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "DimensionBuilder.DimensionInfo(dim=" + this.getDim() + ", customData=" + this.getCustomData() + ", hasSkyLight=" + this.hasSkyLight() + ", keepLoaded=" + this.keepLoaded() + ")";
        }
    }
}

