/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.client.particle.ExtraParticles;
import com.lovetropics.extras.command.GenerateCommand;
import com.lovetropics.extras.command.SetMaxPlayersCommand;
import com.lovetropics.extras.network.LTExtrasNetwork;
import com.lovetropics.extras.repack.registrate.Registrate;
import com.lovetropics.extras.repack.registrate.providers.ProviderType;
import com.lovetropics.extras.repack.registrate.util.entry.RegistryEntry;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod(value="ltextras")
public class LTExtras {
    public static final String MODID = "ltextras";
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("ltextras"){

        public ItemStack m_6976_() {
            return ExtraBlocks.BUOY.asStack();
        }

        public void m_6151_(NonNullList<ItemStack> stacks) {
            super.m_6151_(stacks);
            List order = LTExtras.registrate().getAll(Item.class).stream().map(RegistryEntry::get).collect(Collectors.toList());
            stacks.sort(Comparator.comparingInt(i -> order.indexOf(i.m_41720_())));
        }
    };
    private static NonNullLazy<Registrate> registrate = NonNullLazy.of(() -> (Registrate)Registrate.create(MODID).creativeModeTab(() -> ITEM_GROUP));
    private static final Pattern QUALIFIER = Pattern.compile("-\\w+\\+\\d+");

    public static Registrate registrate() {
        return (Registrate)registrate.get();
    }

    public LTExtras() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(LTExtras::getCompatVersion, (s, v) -> LTExtras.isCompatibleVersion(s)));
        ExtraBlocks.init();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ExtraParticles.REGISTER.register(modBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modBus.addListener(this::clientSetup);
            modBus.addListener(this::registerItemColors);
        });
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        LTExtras.registrate().addDataGenerator(ProviderType.LANG, p -> p.add(ITEM_GROUP, "LTExtras"));
        ModList.get().getModContainerById("worldedit").ifPresent(worldedit -> {
            ModLoadingContext.get().setActiveContainer(worldedit);
            ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        });
        LTExtrasNetwork.register();
    }

    public static String getCompatVersion() {
        return LTExtras.getCompatVersion(((ModContainer)ModList.get().getModContainerById(MODID).orElseThrow(IllegalStateException::new)).getModInfo().getVersion().toString());
    }

    private static String getCompatVersion(String fullVersion) {
        return QUALIFIER.matcher(fullVersion).replaceAll("");
    }

    public static boolean isCompatibleVersion(String version) {
        return LTExtras.getCompatVersion().equals(LTExtras.getCompatVersion(version));
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        SetMaxPlayersCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        GenerateCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        ForgeConfig.CLIENT.alwaysSetupTerrainOffThread.set((Object)true);
        ((ForgeConfigSpec)ObfuscationReflectionHelper.getPrivateValue(ForgeConfig.class, null, (String)"clientSpec")).save();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item evt) {
        evt.getItemColors().m_92689_((stack, index) -> index == 0 ? Fluids.f_76193_.getAttributes().getColor() : -1, new ItemLike[]{(ItemLike)ExtraBlocks.WATER_BARRIER.get(), (ItemLike)ExtraBlocks.FAKE_WATER.get()});
    }
}

