/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras;

import com.google.common.base.Preconditions;
import com.lovetropics.extras.repack.registrate.util.entry.RegistryEntry;
import com.lovetropics.extras.repack.registrate.util.nullness.NonNullSupplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public interface NamedSupplier<T extends IForgeRegistryEntry<T>>
extends NonNullSupplier<T> {
    public static <T extends IForgeRegistryEntry<T>> NamedSupplier<T> of(T entry) {
        return NamedSupplier.of(entry.getRegistryName(), () -> entry);
    }

    public static <T extends IForgeRegistryEntry<T>> NamedSupplier<T> of(RegistryObject<T> object) {
        return NamedSupplier.of(object.getId(), () -> object.get());
    }

    public static <T extends IForgeRegistryEntry<T>> NamedSupplier<T> of(IForgeRegistry<T> registry, ResourceLocation id) {
        return NamedSupplier.of(id, () -> {
            IForgeRegistryEntry value = registry.getValue(id);
            return (IForgeRegistryEntry)Preconditions.checkNotNull((Object)value, (Object)("missing value for " + id + " in " + registry.getRegistryName()));
        });
    }

    public static <T extends IForgeRegistryEntry<T>> NamedSupplier<T> of(RegistryEntry<T> entry) {
        return NamedSupplier.of(entry.getId(), entry);
    }

    public static <T extends IForgeRegistryEntry<T>> NamedSupplier<T> of(final ResourceLocation id, final NonNullSupplier<T> supplier) {
        return new NamedSupplier<T>(){

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public T get() {
                return (IForgeRegistryEntry)supplier.get();
            }

            public int hashCode() {
                return id.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof NamedSupplier) {
                    ResourceLocation otherId = ((NamedSupplier)obj).getId();
                    return this.getId().equals((Object)otherId);
                }
                return false;
            }
        };
    }

    public ResourceLocation getId();

    @Override
    public T get();
}

