/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.block;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class PianguasBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final BooleanProperty UP = PipeBlock.f_55152_;
    private static final BooleanProperty DOWN = PipeBlock.f_55153_;
    private static final BooleanProperty NORTH = PipeBlock.f_55148_;
    private static final BooleanProperty EAST = PipeBlock.f_55149_;
    private static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    private static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final Map<Direction, BooleanProperty> ATTACHMENTS = PipeBlock.f_55154_;
    private static final VoxelShape UP_SHAPE = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Direction[] DIRECTIONS = Direction.values();
    private final Map<BlockState, VoxelShape> stateToShape;

    public PianguasBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.stateToShape = this.f_49792_.m_61056_().stream().collect(Collectors.toMap(Function.identity(), PianguasBlock::getShapeForState));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.stateToShape.get(state);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return PianguasBlock.hasAttachments(PianguasBlock.removeInvalidAttachments(state, (BlockGetter)world, pos));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState currentState = world.m_8055_(pos = context.m_8083_());
        boolean extend = currentState.m_60713_((Block)this);
        BlockState placementState = extend ? currentState : this.m_49966_();
        Fluid fluid = world.m_6425_(pos).m_76152_();
        placementState = (BlockState)placementState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.f_76193_));
        for (Direction direction : context.m_6232_()) {
            boolean replacing;
            BooleanProperty property = PianguasBlock.getPropertyFor(direction);
            boolean bl = replacing = extend && (Boolean)currentState.m_61143_((Property)property) != false;
            if (replacing || !PianguasBlock.canAttachTo((BlockGetter)world, pos.m_142300_(direction), direction)) continue;
            return (BlockState)placementState.m_61124_((Property)property, (Comparable)Boolean.valueOf(true));
        }
        return extend ? placementState : null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState adjacentState, LevelAccessor world, BlockPos currentPos, BlockPos adjacentPos) {
        BlockState newState = PianguasBlock.removeInvalidAttachments(state, (BlockGetter)world, currentPos);
        if (!PianguasBlock.hasAttachments(newState)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return newState;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        BlockState currentState = context.m_43725_().m_8055_(context.m_8083_());
        if (currentState.m_60713_((Block)this)) {
            return PianguasBlock.getAttachmentCount(currentState) < ATTACHMENTS.size();
        }
        return super.m_6864_(state, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(state, mirror);
    }

    public static boolean canAttachTo(BlockGetter world, BlockPos attachPos, Direction direction) {
        BlockState attachState = world.m_8055_(attachPos);
        VoxelShape attachShape = attachState.m_60812_(world, attachPos);
        return Block.m_49918_((VoxelShape)attachShape, (Direction)direction.m_122424_());
    }

    private static BlockState removeInvalidAttachments(BlockState state, BlockGetter world, BlockPos pos) {
        for (Direction direction : DIRECTIONS) {
            BlockPos attachPos;
            BooleanProperty property = PianguasBlock.getPropertyFor(direction);
            if (!((Boolean)state.m_61143_((Property)property)).booleanValue() || PianguasBlock.canAttachTo(world, attachPos = pos.m_142300_(direction), direction)) continue;
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    private static VoxelShape getShapeForState(BlockState state) {
        VoxelShape shape = Shapes.m_83040_();
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            shape = UP_SHAPE;
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            shape = DOWN_SHAPE;
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        return shape;
    }

    private static boolean hasAttachments(BlockState state) {
        return PianguasBlock.getAttachmentCount(state) > 0;
    }

    private static int getAttachmentCount(BlockState state) {
        int count = 0;
        for (BooleanProperty property : ATTACHMENTS.values()) {
            if (!((Boolean)state.m_61143_((Property)property)).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    private static BooleanProperty getPropertyFor(Direction side) {
        return ATTACHMENTS.get(side);
    }
}

