/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.data;

import com.lovetropics.extras.BlockFactory;
import com.lovetropics.extras.repack.registrate.Registrate;
import com.lovetropics.extras.repack.registrate.builders.BlockBuilder;
import com.lovetropics.extras.repack.registrate.util.nullness.NonNullSupplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ModelFile;

public final class ImposterBlockTemplate {
    public final BlockFactory<? extends Block> factory;
    public final Model model;

    public ImposterBlockTemplate(BlockFactory<? extends Block> factory, Model model) {
        this.factory = factory;
        this.model = model;
    }

    public static ImposterBlockTemplate simpleCube() {
        return ImposterBlockTemplate.cube(Block::new);
    }

    public static ImposterBlockTemplate cube(BlockFactory<? extends Block> factory) {
        return new ImposterBlockTemplate(factory, Model.CUBE);
    }

    public static ImposterBlockTemplate cross(BlockFactory<? extends Block> factory) {
        return new ImposterBlockTemplate(factory, Model.CROSS);
    }

    public static enum Model {
        CUBE,
        CROSS;


        public BlockBuilder<? extends Block, Registrate> apply(BlockBuilder<? extends Block, Registrate> block, ResourceLocation id) {
            switch (this) {
                case CUBE: {
                    return block.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(id))).simpleItem();
                }
                case CROSS: {
                    ResourceLocation texture = new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_());
                    return ((BlockBuilder)block.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cross(ctx.getName(), texture))).item().model((ctx, prov) -> prov.generated((NonNullSupplier<? extends ItemLike>)ctx, texture)).build()).addLayer(() -> RenderType::m_110463_);
                }
            }
            return block;
        }
    }
}

