/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.perf;

import com.lovetropics.extras.perf.LossyChunkCache;
import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkCache.class})
public abstract class ServerChunkProviderMixin {
    @Shadow
    @Final
    public ChunkMap f_8325_;
    @Shadow
    @Final
    private Thread f_8330_;
    @Shadow
    @Final
    private ServerChunkCache.MainThreadExecutor f_8332_;
    @Shadow
    @Final
    private DistanceManager f_8327_;
    @Shadow
    @Final
    public ServerLevel f_8329_;
    @Unique
    private final LossyChunkCache fastCache = new LossyChunkCache(32);

    @Inject(method={"clearCache"}, at={@At(value="HEAD")})
    private void invalidateCaches(CallbackInfo ci) {
        this.fastCache.clear();
    }

    @Nullable
    @Overwrite
    public ChunkAccess m_7587_(int x, int z, ChunkStatus status, boolean load) {
        if (load) {
            if (Thread.currentThread() != this.f_8330_) {
                return this.getOrLoadChunkOffThread(x, z, status);
            }
            return this.getOrLoadChunkOnThread(x, z, status);
        }
        return this.getExistingChunk(x, z, status);
    }

    private ChunkAccess getOrLoadChunkOnThread(int x, int z, ChunkStatus status) {
        Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure> result;
        ChunkAccess cached = this.fastCache.get(x, z, status);
        if (cached != null) {
            return cached;
        }
        ChunkHolder holder = this.m_8364_(ChunkPos.m_45589_((int)x, (int)z));
        ChunkAccess chunk = this.getExistingChunkFor(holder, status);
        if (chunk == null && (chunk = (ChunkAccess)(result = this.joinFuture(this.loadChunk(x, z, status))).left().orElse(null)) == null) {
            throw new IllegalStateException("Chunk not there when requested: " + result.right().orElse(null));
        }
        this.fastCache.put(x, z, status, chunk);
        return chunk;
    }

    private <T> T joinFuture(CompletableFuture<T> future) {
        if (!future.isDone()) {
            this.f_8332_.m_18701_(future::isDone);
        }
        return future.join();
    }

    private ChunkAccess getOrLoadChunkOffThread(int x, int z, ChunkStatus status) {
        Either result = (Either)CompletableFuture.supplyAsync(() -> this.loadChunk(x, z, status), (Executor)this.f_8332_).join().join();
        ChunkAccess chunk = result.left().orElse(null);
        if (chunk != null) {
            return chunk;
        }
        throw new IllegalStateException("Chunk not there when requested: " + result.right().orElse(null));
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> loadChunk(int x, int z, ChunkStatus status) {
        long chunkKey = ChunkPos.m_45589_((int)x, (int)z);
        ChunkHolder holder = this.m_8364_(chunkKey);
        int level = ServerChunkProviderMixin.getLevelForStatus(status);
        ChunkPos chunkPos = new ChunkPos(x, z);
        this.f_8327_.m_140792_(TicketType.f_9449_, chunkPos, level, (Object)chunkPos);
        if (!ServerChunkProviderMixin.isValidForLevel(holder, level)) {
            this.m_8489_();
            holder = this.m_8364_(chunkKey);
            if (!ServerChunkProviderMixin.isValidForLevel(holder, level)) {
                throw new IllegalStateException("No chunk holder after ticket has been added");
            }
        }
        return holder.m_140049_(status, this.f_8325_);
    }

    @Overwrite
    @Nullable
    public LevelChunk m_7131_(int x, int z) {
        return (LevelChunk)this.getExistingChunk(x, z, ChunkStatus.f_62326_);
    }

    private ChunkAccess getExistingChunk(int x, int z, ChunkStatus status) {
        if (Thread.currentThread() != this.f_8330_) {
            return this.loadExistingChunk(x, z, status);
        }
        ChunkAccess cached = this.fastCache.get(x, z, status);
        if (cached != null) {
            return cached;
        }
        ChunkAccess chunk = this.loadExistingChunk(x, z, status);
        this.fastCache.put(x, z, status, chunk);
        return chunk;
    }

    @Nullable
    private ChunkAccess loadExistingChunk(int x, int z, ChunkStatus status) {
        ChunkHolder holder = this.m_8364_(ChunkPos.m_45589_((int)x, (int)z));
        return this.getExistingChunkFor(holder, status);
    }

    @Nullable
    private ChunkAccess getExistingChunkFor(@Nullable ChunkHolder holder, ChunkStatus status) {
        if (ServerChunkProviderMixin.isValidForStatus(holder, status)) {
            CompletableFuture future = holder.m_140047_(status);
            return future.getNow(ChunkHolder.f_139995_).left().orElse(null);
        }
        return null;
    }

    @Overwrite
    public boolean m_5563_(int x, int z) {
        return this.getExistingChunk(x, z, ChunkStatus.f_62326_) != null;
    }

    private static boolean isValidForStatus(ChunkHolder holder, ChunkStatus status) {
        return holder != null && holder.m_140093_() <= ServerChunkProviderMixin.getLevelForStatus(status);
    }

    private static int getLevelForStatus(ChunkStatus status) {
        return 33 + ChunkStatus.m_62370_((ChunkStatus)status);
    }

    private static boolean isValidForLevel(@Nullable ChunkHolder holder, int level) {
        return holder != null && holder.m_140093_() <= level;
    }

    @Shadow
    @Nullable
    protected abstract ChunkHolder m_8364_(long var1);

    @Shadow
    protected abstract boolean m_8489_();
}

