/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.perf;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;

public final class LossyChunkCache {
    private static final int COORD_BITS = 30;
    private static final int COORD_MASK = 0x3FFFFFFF;
    private static final int STATUS_BITS = 4;
    private static final int STEP_MASK = 15;
    private final int mask;
    private final long[] keys;
    private final ChunkAccess[] values;

    public LossyChunkCache(int capacity) {
        capacity = Mth.m_14125_((int)capacity);
        this.mask = capacity - 1;
        this.keys = new long[capacity];
        this.values = new ChunkAccess[capacity];
    }

    public void clear() {
        Arrays.fill(this.keys, Long.MIN_VALUE);
        Arrays.fill(this.values, null);
    }

    public void put(int x, int z, ChunkStatus status, ChunkAccess chunk) {
        if (chunk == null) {
            return;
        }
        long key = LossyChunkCache.key(x, z, status);
        int index = this.index(key);
        this.keys[index] = key;
        this.values[index] = chunk;
    }

    @Nullable
    public ChunkAccess get(int x, int z, ChunkStatus step) {
        long key = LossyChunkCache.key(x, z, step);
        int index = this.index(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return null;
    }

    private static long key(int x, int z, ChunkStatus step) {
        return (long)(x & 0x3FFFFFFF) << 34 | (long)(z & 0x3FFFFFFF) << 4 | (long)(step.m_62445_() & 0xF);
    }

    private int index(long key) {
        return (int)HashCommon.mix((long)key) & this.mask;
    }
}

