/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.repack.ltlib;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record BlockBox(BlockPos min, BlockPos max) implements Iterable<BlockPos>
{
    public static final Codec<BlockBox> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockPos.f_121852_.fieldOf("min").forGetter(c -> c.min), (App)BlockPos.f_121852_.fieldOf("max").forGetter(c -> c.max)).apply((Applicative)i, BlockBox::of));

    public static BlockBox of(BlockPos pos) {
        return new BlockBox(pos, pos);
    }

    public static BlockBox of(BlockPos a, BlockPos b) {
        return new BlockBox(BlockBox.min(a, b), BlockBox.max(a, b));
    }

    public static BlockBox ofChunk(int chunkX, int chunkZ) {
        return new BlockBox(new BlockPos(chunkX << 4, 0, chunkZ << 4), new BlockPos((chunkX << 4) + 15, 256, (chunkZ << 16) + 15));
    }

    public static BlockBox ofChunk(ChunkPos chunkPos) {
        return BlockBox.ofChunk(chunkPos.f_45578_, chunkPos.f_45579_);
    }

    public static BlockPos min(BlockPos a, BlockPos b) {
        return new BlockPos(Math.min(a.m_123341_(), b.m_123341_()), Math.min(a.m_123342_(), b.m_123342_()), Math.min(a.m_123343_(), b.m_123343_()));
    }

    public static BlockPos max(BlockPos a, BlockPos b) {
        return new BlockPos(Math.max(a.m_123341_(), b.m_123341_()), Math.max(a.m_123342_(), b.m_123342_()), Math.max(a.m_123343_(), b.m_123343_()));
    }

    public BlockBox withMin(BlockPos min) {
        return BlockBox.of(min, this.max);
    }

    public BlockBox withMax(BlockPos max) {
        return BlockBox.of(this.min, max);
    }

    public BlockBox offset(double x, double y, double z) {
        return new BlockBox(this.min.m_142022_(x, y, z), this.max.m_142022_(x, y, z));
    }

    public Vec3 center() {
        return new Vec3(((double)(this.min.m_123341_() + this.max.m_123341_()) + 1.0) / 2.0, ((double)(this.min.m_123342_() + this.max.m_123342_()) + 1.0) / 2.0, ((double)(this.min.m_123343_() + this.max.m_123343_()) + 1.0) / 2.0);
    }

    public BlockPos centerBlock() {
        return new BlockPos((this.min.m_123341_() + this.max.m_123341_() + 1) / 2, (this.min.m_123342_() + this.max.m_123342_() + 1) / 2, (this.min.m_123343_() + this.max.m_123343_() + 1) / 2);
    }

    public BlockPos size() {
        return new BlockPos(this.max.m_123341_() - this.min.m_123341_() + 1, this.max.m_123342_() - this.min.m_123342_() + 1, this.max.m_123343_() - this.min.m_123343_() + 1);
    }

    public long volume() {
        long sizeX = this.max.m_123341_() - this.min.m_123341_() + 1;
        long sizeY = this.max.m_123342_() - this.min.m_123342_() + 1;
        long sizeZ = this.max.m_123343_() - this.min.m_123343_() + 1;
        return sizeX * sizeY * sizeZ;
    }

    public BlockPos sample(Random random) {
        return new BlockPos(this.min.m_123341_() + random.nextInt(this.max.m_123341_() - this.min.m_123341_() + 1), this.min.m_123342_() + random.nextInt(this.max.m_123342_() - this.min.m_123342_() + 1), this.min.m_123343_() + random.nextInt(this.max.m_123343_() - this.min.m_123343_() + 1));
    }

    public boolean contains(BlockPos pos) {
        return this.contains(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public boolean contains(Vec3 pos) {
        return this.contains(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public boolean contains(double x, double y, double z) {
        BlockPos min = this.min;
        BlockPos max = this.max;
        return x >= (double)min.m_123341_() && y >= (double)min.m_123342_() && z >= (double)min.m_123343_() && x < (double)max.m_123341_() + 1.0 && y < (double)max.m_123342_() + 1.0 && z < (double)max.m_123343_() + 1.0;
    }

    public boolean contains(int x, int y, int z) {
        BlockPos min = this.min;
        BlockPos max = this.max;
        return x >= min.m_123341_() && y >= min.m_123342_() && z >= min.m_123343_() && x <= max.m_123341_() && y <= max.m_123342_() && z <= max.m_123343_();
    }

    public boolean intersects(AABB aabb) {
        return aabb.m_82314_((double)this.min.m_123341_(), (double)this.min.m_123342_(), (double)this.min.m_123343_(), (double)this.max.m_123341_() + 1.0, (double)this.max.m_123342_() + 1.0, (double)this.max.m_123343_() + 1.0);
    }

    public boolean intersects(BlockBox other) {
        return this.max.m_123341_() >= other.min.m_123341_() && this.min.m_123341_() <= other.max.m_123341_() && this.max.m_123342_() >= other.min.m_123342_() && this.min.m_123342_() <= other.max.m_123342_() && this.max.m_123343_() >= other.min.m_123343_() && this.min.m_123343_() <= other.max.m_123343_();
    }

    @Nullable
    public BlockBox intersection(BlockBox other) {
        BlockPos min = BlockBox.max(this.min, other.min);
        BlockPos max = BlockBox.min(this.max, other.max);
        if (min.m_123341_() >= max.m_123341_() || min.m_123342_() >= max.m_123342_() || min.m_123343_() >= max.m_123343_()) {
            return null;
        }
        return new BlockBox(min, max);
    }

    public AABB asAabb() {
        return new AABB((double)this.min.m_123341_(), (double)this.min.m_123342_(), (double)this.min.m_123343_(), (double)this.max.m_123341_() + 1.0, (double)this.max.m_123342_() + 1.0, (double)this.max.m_123343_() + 1.0);
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return BlockPos.m_121940_((BlockPos)this.min, (BlockPos)this.max).iterator();
    }

    public LongSet asChunks() {
        LongOpenHashSet chunks = new LongOpenHashSet();
        int minChunkX = this.min.m_123341_() >> 4;
        int minChunkZ = this.min.m_123343_() >> 4;
        int maxChunkX = this.max.m_123341_() >> 4;
        int maxChunkZ = this.max.m_123343_() >> 4;
        for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                chunks.add(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
            }
        }
        return chunks;
    }

    public CompoundTag write(CompoundTag root) {
        root.m_128365_("min", (Tag)BlockBox.writeBlockPos(this.min, new CompoundTag()));
        root.m_128365_("max", (Tag)BlockBox.writeBlockPos(this.max, new CompoundTag()));
        return root;
    }

    public static BlockBox read(CompoundTag root) {
        BlockPos min = BlockBox.readBlockPos(root.m_128469_("min"));
        BlockPos max = BlockBox.readBlockPos(root.m_128469_("max"));
        return new BlockBox(min, max);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.min);
        buffer.m_130064_(this.max);
    }

    public static BlockBox read(FriendlyByteBuf buffer) {
        BlockPos min = buffer.m_130135_();
        BlockPos max = buffer.m_130135_();
        return new BlockBox(min, max);
    }

    private static CompoundTag writeBlockPos(BlockPos pos, CompoundTag root) {
        root.m_128405_("x", pos.m_123341_());
        root.m_128405_("y", pos.m_123342_());
        root.m_128405_("z", pos.m_123343_());
        return root;
    }

    private static BlockPos readBlockPos(CompoundTag root) {
        return new BlockPos(root.m_128451_("x"), root.m_128451_("y"), root.m_128451_("z"));
    }
}

