/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.repack.ltlib.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public final class FireworkPalette {
    private static final Random RANDOM = new Random();
    static final int CE_YELLOW = 16041012;
    static final int CE_BLUE = 6666715;
    static final int CE_GREEN = 11653785;
    static final int CE_RED = 15356243;
    static final int CE_ORANGE = 15763271;
    static final int CE_PURPLE = 8478886;
    static final int CE_NAVY = 3752019;
    public static final FireworkPalette DYE_COLORS = new FireworkPalette(new int[0][]);
    public static final FireworkPalette PUERTO_RICO = new FireworkPalette(new int[][]{{11743532, 0xF0F0F0, 2437522, 6998340, 16105792, 1021572}});
    public static final FireworkPalette COOL_EARTH = new FireworkPalette({16041012, 6666715, 11653785}, {15356243, 15763271, 8478886}, {16041012, 6666715, 8478886}, {6666715, 11653785, 3752019});
    public static final FireworkPalette OSA_CONSERVATION = new FireworkPalette({9028897, 13271357, 37119, 2428418}, {9028897, 13271357, 37119, 0xFEFFEA});
    public static final FireworkPalette ISLAND_ROYALE = new FireworkPalette(new int[][]{{0}});
    private final int[][] palette;

    private FireworkPalette(int[] ... palette) {
        this.palette = palette;
    }

    public int[][] getPalette() {
        return this.palette;
    }

    @Nonnull
    public FireworkRocketEntity create(@Nonnull Level level) {
        return this.create(level, BlockPos.f_121853_);
    }

    @Nonnull
    public FireworkRocketEntity create(@Nonnull Level level, @Nonnull BlockPos pos) {
        int[] colors;
        ItemStack firework = new ItemStack((ItemLike)Items.f_42688_);
        firework.m_41751_(new CompoundTag());
        CompoundTag explosion = new CompoundTag();
        explosion.m_128379_("Flicker", true);
        explosion.m_128379_("Trail", true);
        if (this.palette.length == 0) {
            colors = new int[RANDOM.nextInt(8) + 1];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = DyeColor.values()[RANDOM.nextInt(16)].m_41070_();
            }
        } else {
            int[] palette = this.palette[RANDOM.nextInt(this.palette.length)];
            colors = new int[palette.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = palette[RANDOM.nextInt(palette.length)];
            }
        }
        explosion.m_128385_("Colors", colors);
        byte type = (byte)(RANDOM.nextInt(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        explosion.m_128344_("Type", type);
        ListTag explosions = new ListTag();
        explosions.add((Object)explosion);
        CompoundTag fireworkTag = new CompoundTag();
        fireworkTag.m_128365_("Explosions", (Tag)explosions);
        fireworkTag.m_128344_("Flight", (byte)1);
        firework.m_41700_("Fireworks", (Tag)fireworkTag);
        return new FireworkRocketEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, firework);
    }

    public void spawn(@Nonnull BlockPos block, Level level) {
        this.spawn(block, level, 0);
    }

    public void spawn(@Nonnull BlockPos pos, Level level, int range) {
        BlockPos spawnPos = pos;
        if (range > 0) {
            spawnPos = new BlockPos(FireworkPalette.moveRandomly(spawnPos.m_123341_(), range), (double)spawnPos.m_123342_(), FireworkPalette.moveRandomly(spawnPos.m_123343_(), range));
            BlockState bs = level.m_8055_(spawnPos);
            int tries = -1;
            while (!level.m_46859_(new BlockPos((Vec3i)spawnPos)) && !bs.m_60767_().m_76334_()) {
                if (++tries <= 100) continue;
                return;
            }
        }
        level.m_7967_((Entity)this.create(level, spawnPos));
    }

    private static double moveRandomly(double base, double range) {
        return base + 0.5 + RANDOM.nextDouble() * range - range / 2.0;
    }
}

