/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.repack.registrate.providers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.lovetropics.extras.repack.registrate.AbstractRegistrate;
import com.lovetropics.extras.repack.registrate.providers.ProviderType;
import com.lovetropics.extras.repack.registrate.providers.RegistrateProvider;
import com.lovetropics.extras.repack.registrate.util.DebugMarkers;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistrateDataProvider
implements DataProvider {
    private static final Logger log = LogManager.getLogger(RegistrateDataProvider.class);
    static final BiMap<String, ProviderType<?>> TYPES = HashBiMap.create();
    private final String mod;
    private final Map<ProviderType<?>, RegistrateProvider> subProviders = new LinkedHashMap();

    @Nullable
    public static String getTypeName(ProviderType<?> type) {
        return (String)TYPES.inverse().get(type);
    }

    public RegistrateDataProvider(AbstractRegistrate<?> parent, String modid, GatherDataEvent event) {
        this.mod = modid;
        EnumSet<LogicalSide> sides = EnumSet.noneOf(LogicalSide.class);
        if (event.includeServer()) {
            sides.add(LogicalSide.SERVER);
        }
        if (event.includeClient()) {
            sides.add(LogicalSide.CLIENT);
        }
        log.debug(DebugMarkers.DATA, "Gathering providers for sides: {}", sides);
        HashMap known = new HashMap();
        for (String id : TYPES.keySet()) {
            ProviderType type = (ProviderType)TYPES.get((Object)id);
            Object prov = type.create(parent, event, known);
            known.put(type, (RegistrateProvider)prov);
            if (!sides.contains(prov.getSide())) continue;
            log.debug(DebugMarkers.DATA, "Adding provider for type: {}", (Object)id);
            this.subProviders.put(type, (RegistrateProvider)prov);
        }
    }

    public void m_6865_(HashCache cache) throws IOException {
        for (Map.Entry<ProviderType<?>, RegistrateProvider> e : this.subProviders.entrySet()) {
            log.debug(DebugMarkers.DATA, "Generating data for type: {}", (Object)RegistrateDataProvider.getTypeName(e.getKey()));
            e.getValue().m_6865_(cache);
        }
    }

    public String m_6055_() {
        return "Registrate Provider for " + this.mod + " [" + this.subProviders.values().stream().map(DataProvider::m_6055_).collect(Collectors.joining(", ")) + "]";
    }

    public <P extends RegistrateProvider> Optional<P> getSubProvider(ProviderType<P> type) {
        return Optional.ofNullable(this.subProviders.get(type));
    }
}

